import MItem from "../components/MItem";
import { MConfigs } from "../MConfigs";
import ViewAchievementPanel from "../panel/ViewAchievementPanel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";

/**服务端成就数据
     * { id: 0, locked: false}
     */
export default class AchievementItem extends MItem {
    public pic: eui.Image;
    public picNot: eui.Image;
    public btnEnter: eui.Button;
    public achievementName: eui.Label;

    preLoad() {
        return RES.loadGroup("achievement_panel");
    }

    async onSkinComplete() {
        super.onSkinComplete();

        let configData = MConfigs.achievement[this.data["id"]];

        this.achievementName.text = configData["name"];

        if (this.data["locked"]) {
            this.pic.texture = RES.getRes(`achievement_pic_not_${configData.id}_png`);
        } else {
            this.pic.texture = RES.getRes(`achievement_pic_normal_${configData.id}_png`);
        }

        this.pic.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (!this.data["locked"]) {
                GDispatcher.dispatchEvent("closeAchievement")
                PanelCtrl.instance.show(ModuleTypes.VIEW_ACHIEVEMENT_PANEL, {configData:configData,index:this.data["id"],gmtCreate:this.data.gmtCreate});
            }
        }, this);
    }
}