export class FriendItemComponent extends eui.Component{
    public photoMask:eui.Rect;
    public photoImg:eui.Image;
    public userNameText:eui.Label;
    public speedText:eui.Label;
    public timerText:eui.Label;    

    private photo;
    private uname;
    private timer;

    
    /**
     * 
     * @param photo 头像
     * @param uname 用户名
     * @param speed 速度
     * @param timer 事件
     */
    constructor(photo,uname:string,timer){
        super();
        this.skinName       = 'resource/skins/component/FriendItemComponent.exml';

        this.photo = photo;
        this.uname = uname;
        this.timer = timer;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.photoImg.mask=this.photoMask;
        this.photoImg.source=this.photo;
        if(this.uname){
            if(this.uname.length<=7){
                this.userNameText.text=this.uname; 
            }else{
                this.userNameText.text=this.uname.slice(0,7)+"..."; 
            }
        }
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    setTime(timer){
        this.timer=timer;
        this.timerText.text=this.timer;
    }

    public removeEvent():void{
    }

    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}