import Panel from "../views/Panel";
import { MUtils } from "../MUtils";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { MConfigs } from "../MConfigs";
import QuestListItem from "../item/QuestListItem";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class QuestListPanel extends Panel {
    public get skinKey() { return "QuestListPanel" }
    public get groupName() { return "quest_list" }

    public progressVisit: eui.ProgressBar;
    public visit3day: eui.Button;
    public visit7day: eui.Button;
    public visit15day: eui.Button;
    public list: eui.DataGroup;
    public closeBtn: eui.Button;


    private colorMatrix = [
        0.3,0.6,0,0,0,
        0.3,0.6,0,0,0,
        0.3,0.6,0,0,0,
        0,0,0,1,0
    ];

    private colorFlilter = new egret.ColorMatrixFilter(this.colorMatrix);

    constructor(data?: any) {
        super(data);
    }

    start(data?: any) {
        super.start(data);
    }

    protected async preLoadRes() {
        await RES.loadGroup(this.groupName);
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    private showVisitRewardPanel(day: number, reward: number) {
        PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, {
            title: `完成连续${day}天访问活动`,
            rewardNum: reward
        });
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.updateData()
    }


    updateData(){

        this.visit3day.filters=[this.colorFlilter]
        let data = [
            {
                id: 0,
                status: 3,
                rewardId: null,
            },
            {
                id: 1,
                status: 0,
                rewardId: null
            },
            {
                id: 2,
                status: 2,
                rewardId: 0
            },
            {
                id: 3,
                status: 0,
                rewardId: null
            },
            {
                id: 4,
                status: 0,
                rewardId: null
            }
        ]
        data.forEach(e => {
            e["context"] = this;
        });

        let dataJson=DataManager.ins.getData(NetName.TASK_INFO_KUWO).data.tasks;
        console.log("dataJson")
        console.log(dataJson)
        
        for(let i=0;i<dataJson.length;i++){

            let index=0
            if(dataJson[i].type==1){
                index=1
            }else if(dataJson[i].type==2){
                index=3
            }else if(dataJson[i].type==3){
                index=4
            }else if(dataJson[i].type==4){
                index=2
            }

            data[index]["type"]=dataJson[i].type
            data[index]["completedCount"]=dataJson[i].completedCount
            data[index]["dailyLimitCount"]=dataJson[i].dailyLimitCount
           
            if(dataJson[i].completedCount>=dataJson[i].dailyLimitCount){
                //已完成
                console.log("已完成")
                data[index].status=3
            }else if(dataJson[i].completedCount<dataJson[i].dailyLimitCount&&dataJson[i].completedCount!=0){
                //进行中
                console.log("进行中")
                data[index].status=1
            }else if(dataJson[i].completedCount==0){
                //去完成
                console.log("去完成")
                data[index].status=0
            }
           
        }

        this.list.dataProvider = new eui.ArrayCollection(data);
        this.list.itemRenderer = QuestListItem;
    }

    async initEvents() {
        super.initEvents();

        this.visit3day.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.showVisitRewardPanel(3, 20);
        }, this);
        this.visit7day.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.showVisitRewardPanel(7, 50);
        }, this);
        this.visit15day.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.showVisitRewardPanel(15, 100);
        }, this);

    }
}