import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import { NetName } from "../libs/tw/enum/NetName";
import { NetPromise } from "./NetPromise";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetBuried } from "./NetBuried";

export namespace MConfigs {
    export let achievement = {
        1: { id: "0", name: "路人甲", },
        2: { id: "0", name: "练习生" },
        3: { id: "1", name: "扛琴小弟" },
        4: { id: "2", name: "乐队主唱" },
        5: { id: "3", name: "酒吧驻唱" },
        6: { id: "4", name: "签约艺人" },
        7: { id: "5", name: "偶像巨星" }
    }

    export let quest = {
        0: {
            id: "0",
            name: "首次到访",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成首次到访");
                NetBuried.ins.clickLog(14)
            }
        },
        1: {
            id: "1",
            name: "个人中心签到",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成个人中心签到");
                NetBuried.ins.clickLog(15)
                NetPromise.ins.completeTaskKuwo(window["eduSignId"], 1)
                    .then(() => {
                        localStorage.setItem("signGold", DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0)
                        window.location.href = "https://m.kuwo.cn/newh5/score/index"
                    })
            },
        },
        2: {
            id: "2",
            name: "每日分享",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                console.log("去完成每日分享");
                NetBuried.ins.clickLog(16)
                NetPromise.ins.handleShare()
                    .then(() => {
                        return NetPromise.ins.completeTaskKuwo(window["eduSignId"], 4)
                    })
                    .then(() => {
                        console.log("分享成功")
                        PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, {
                            title: `分享成功`,
                            rewardNum: DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0
                        });
                    })
            },
        },
        3: {
            id: "3",
            name: "收藏歌曲",
            reward: "零花钱+20金币",
            maxTime: 3,
            todo: () => {
                NetBuried.ins.clickLog(17)
                NetPromise.ins.forFavor(window["loginUid"], window["sid"])
                    .then(() => {
                        PanelCtrl.instance.show(ModuleTypes.FAVORITE_MUSIC_PANEL);
                    })
            },
        },
        4: {
            id: "4",
            name: "收听歌曲",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                NetBuried.ins.clickLog(18)
                NetPromise.ins.forFavor(window["loginUid"], window["sid"])
                    .then(() => {
                        PanelCtrl.instance.show(ModuleTypes.LISTEN_MUSIC_PANEL);
                    })
            }
        }
    }

    export let msgsAuto = [
        "你是碳酸饮料吧？\n让我一见到就开心冒泡。",
        "我要的不多，只要你。\n我有的不多，全给你。",
        "我不属于十二星座，\n只是为你量身定做。",
        "没有甜品的时候，\n小酷只好想想你了。",
        "我是可爱的小酷，\n你是可爱。",
        "今天不吃大碗宽面，\n只想住你心里面。",
        "只许州官放火，\n不许你离开我。",
        "你点开了我，\n我想点开你的心。",
        "我一点也不想你，\n一点半再想。",
        "小酷请你吃种梨，\n酷我黑风梨。"
    ]

    export let msgsPlay = [
        "好希望主人永远陪在我身边",
    ]

    export let msgsMusic = [
        "朕去搞乐队咯！\n晚点回来，拜拜了您内",
    ]

    export let msgsSickkeep = [
        "嘤嘤嘤～好难受，\n主人不要本宝宝了么？",
    ]

    export let msgsSick = [
        "满血复活！\n本宝宝又是条好汉啦",
    ]

    export let msgsFood = [
        "我只想多吃一点点，\n肉肉都看不见",
    ]

    export let msgsOther = [
        "宝宝吃不下啦～\n明天再喂我吧！",
        "音浪太强，\n本小喵咪想静静！",
        "本宝宝累了～\n绳命在于静止！",
    ]

    export let msgsError = [
        "金币不够呢，\n先去做任务赚金币吧！",
    ]
}