import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Loading from "../loading/Loading";

export default class TopLayerCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Sprite;

    static _instance: TopLayerCtrl;
    static get instance() {
        return TopLayerCtrl._instance || (TopLayerCtrl._instance = new TopLayerCtrl())
    }

    private canvasH = 750 / window.innerWidth * window.innerHeight;
    private canvasW = 750 / window.innerWidth * window.innerWidth;

    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    show(type: ModuleTypes, data?, maskAlpha: number = 0) {
        if(this._current) {
            this.remove(this._current);
            // this._current = null;
        }

        this.addMask(maskAlpha);
        this._parent.visible = true;
        const cls = this._panelClassMap[type];

        Loading.instace.show();
        const panel: Panel = new cls(data);
        this._current = panel;

        this.add(panel);

    }

    /**
     * 加入黑色蒙层
     */
    private addMask(maskAlpha: number) {
        /// TODO 临时改造，将生成的mask alpha 设置为 1，使用生成后的Sprite来设置透明度，比免重复的移除和生成
        if(!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, 1);
            this._mask.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = maskAlpha;
        this._parent.addChild(this._mask);
    }

    /**
     * 移除蒙层
     */
    removeMask() {
        /// TODO 不知道谁干的。 暂时认为没必要移除，且移除易造成_mask不是_parent的子渲染项
        // if(this._mask) {
            // this._parent.removeChild(this._mask);
        // }
        this._parent.visible = false;
    }

    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    public btnDelay(targe: any, dtime: number = 500) {
        targe.touchEnabled = false;
        setTimeout(() => {
            targe.touchEnabled = true;
        }, dtime);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.onShowAnim();
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    private remove(panel: Panel) {
        this._current && this._current.destroy();
        this._current = null;
        panel.parent && this._parent.removeChild(panel);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.removeMask();

        if(this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    }

    private panelHide(panel: Panel): void {
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);

        if(this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    }

    private _panelClassMap: any;

    registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }

    public registerPanels(panels) {
        panels.forEach(v => this.registerPanelClass(v[0], v[1]))
    }


    private _current: Panel;

    closeCurrent() {
        if(this._current)
            this.remove(this._current);
    }
}