
import Loading from "../../loading/Loading";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { DataManager } from "../../../libs/tw/manager/DataManager";

const getStartOrderStatus = (callback: Function, customizedType?: number) => {
    NetManager.ins.getStartStatus(
        callback,
        DataManager.ins.doStartData.ticketId,
        () => { return DataManager.ins.getStartStatusData.code != 1; },
        5,
        customizedType);
}
/**
* 开始游戏
* @param {string} isAgain 是否是再来一次
* @param {number} credits 主动要求花费多少积分玩游戏
* @param {number} customizedType xx类型
*/
export default
    (isAgain = false, credits?: number, customizedType?: number) => new Promise((resolve) => {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        const callback = (data) => {
            Loading.instace.hide();
            resolve(data);
        }
        Loading.instace.show();
        NetManager.ins.doStart((success: boolean) => {
            if (success) {
                getStartOrderStatus(callback, customizedType);
            } else {
                callback(success);
            }
        },
            isAgain,
            credits,
            customizedType);
    });