import Scene from "../../views/Scene";
import { btnDelay, getRequestByKey } from "../../comm/UtilsConst";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { getlogItem } from "../../comm/getlogItem";

/**
 * 主场景
 */
export default class IndexScene extends Scene {
    public main: eui.Group;
    public bg: eui.Image;
    public btn: eui.Button;

    constructor(data?) {
        super(data);
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        NetManager.ins.showLog(getlogItem(32));
        window['_hmt'].push(['_trackEvent', '分享打开页面-为好友助力按钮', 'showLog', '曝光']);

        // this.main.height = 750 / window.innerWidth * window.innerHeight;

        this.percentHeight = 100;
        // console.log(this.main.height);
        // this.stage.height = 750 / window.innerWidth * window.innerHeight;

    }

    destroy() {
        super.destroy();

    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTouchTap, this],
        ]);
    }

    private onTouchTap() {
        btnDelay(this.btn);
        NetManager.ins.clickLog(getlogItem(32));
        window['_hmt'].push(['_trackEvent', '分享打开页面-为好友助力按钮', 'clickLog', '点击']);

        let shareCode = getRequestByKey('shareCode');
        // shareCode
        //     ?
        NetManager.ins.doAssist((success, res) => {
            let codeTips = {
                "200001": "您的助力已经达到上限了哦～",
                "200002": "今天助力已满，明天再来给我加油吧～",
                "200013": "已经助力过啦，不能重复助力哦～",
                "200008": "分享码失效啦，需要重新分享哦～",
                "100019": "分享码失效啦，需要重新分享哦～",
                "100013": "分享码失效啦，需要重新分享哦～",
                "200009": "啊哦…自己不能给自己助力哦～",
                "100014": "啊哦…自己不能给自己助力哦～",
                "100020": "啊哦…自己不能给自己助力哦～",
                "100012": "已经助力过啦，不能重复助力哦～",
                "100015": "已经助力过啦，不能重复助力哦～",
            };
            if(!res.success) {
                if(codeTips.hasOwnProperty(res.code)) {
                    PanelCtrl.instance.show(ModuleTypes.ASSISTANCE_PANEL, {
                        success: false,
                        failTips: codeTips[res.code],
                        code: res.code,
                    });
                }
            } else {
                PanelCtrl.instance.show(ModuleTypes.ASSISTANCE_PANEL, {success: true});
            }
        }, shareCode)
        // : 0;
    }

    public get skinKey() {
        return 'IndexScene'
    }

    public get groupName() {
        return 'index_scene'
    }

}