import { NetManager } from "../../../libs/tw/manager/NetManager";
import { getlogItem } from "../../comm/getlogItem";
import Panel from "../../views/Panel";

export default class AssistancePanel extends Panel {

    public bg: eui.Image;
    public heart: eui.Image;
    public failTip: eui.Label;
    public closeBtn: eui.Button;
    public joinBtn: eui.Button;

    public get skinKey() {
        return 'AssistancePanel'
    }

    constructor(data?: any) {
        super(data);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.joinBtn, this.onTap_clickJoin, this],
        ]);
    }

    protected start() {
        super.start();
        this.bg.source = this.data.success ? 'successBg_png' : 'failBg_png';
        this.heart.visible = this.data.success;
        this.failTip.visible = !this.data.success;
        this.failTip.text = this.data.failTips;
        if(this.data.success) {
            NetManager.ins.showLog(getlogItem(35));
            window['_hmt'].push(['_trackEvent', '助力成功按钮', 'showLog', '曝光']);            

        } else {
            // "200001": "您的助力已经达到上限了哦～",

            // "200002": "今天助力已满，明天再来给我加油吧～",

            // "200008": "分享码失效啦，需要重新分享哦～",
            // "100019": "分享码失效啦，需要重新分享哦～",
            // "100013": "分享码失效啦，需要重新分享哦～",

            // "200009": "啊哦…自己不能给自己助力哦～",
            // "100014": "啊哦…自己不能给自己助力哦～",
            // "100020": "啊哦…自己不能给自己助力哦～",

            // "200013": "已经助力过啦，不能重复助力哦～",
            // "100012": "已经助力过啦，不能重复助力哦～",
            // "100015": "已经助力过啦，不能重复助力哦～",

            // "100001": "您的助力已经达到上限了哦～",
            // "100013": "已经助力过啦，不能重复助力哦～"
            if(this.data.code == '200001') {
                NetManager.ins.showLog(getlogItem(33))
                window['_hmt'].push(['_trackEvent', '助力上限弹窗按钮', 'showLog', '曝光']);
            } else if(this.data.code == '200013' || this.data.code == '100012' || this.data.code == '100015') {
                NetManager.ins.showLog(getlogItem(34))
                window['_hmt'].push(['_trackEvent', '助力失败（重复助力）按钮', 'showLog', '曝光']);
            }
        }
    }

    public onTouchClose(): any {
        // if(this.data.success) {
        //     NetManager.ins.clickLog(getlogItem(32));
        // } else {
        //     if(this.data.code == '200001') {
        //         NetManager.ins.clickLog(getlogItem(33))
        //     } else if(this.data.code == '200013' || this.data.code == '100012' || this.data.code == '100015') {
        //         NetManager.ins.clickLog(getlogItem(34))
        //     }
        // }
        return super.onTouchClose();
    }

    private onTap_clickJoin() {
        console.log('我也要去打榜');
        if(this.data.success) {
            NetManager.ins.clickLog(getlogItem(35));
            window['_hmt'].push(['_trackEvent', '助力成功按钮', 'clickLog', '点击']);   
        } else {
            if(this.data.code == '200001') {
                NetManager.ins.clickLog(getlogItem(33))
                window['_hmt'].push(['_trackEvent', '助力上限弹窗按钮', 'clickLog', '点击']);
            } else if(this.data.code == '200013' || this.data.code == '100012' || this.data.code == '100015') {
                NetManager.ins.clickLog(getlogItem(34))
                window['_hmt'].push(['_trackEvent', '助力失败（重复助力）按钮', 'clickLog', '点击']);
            }
        }

        setTimeout(() => {
            window.location.href = window['activeUrl'];
        }, 1000);
        // window['wx'].miniProgram.navigateTo({
        //     url: 'pages/gamePage/gamePage'
        // });
        this.hidePanel();
    }
}