// import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import DataConversion from "../mainScene/DataConversion";
export default class NewPetPanel extends Panel {
    public image: eui.Image;
    public noprize: eui.Group;
    public image0: eui.Image;
    public closeBtn1: eui.Button;
    public prize: eui.Group;
    public image1: eui.Image;
    public closeBtn2: eui.Button;
    public prizeImg: eui.Image;
    public dog_lv_1: eui.Image;
    public dog_lv_2: eui.Image;
    public dog_lv_3: eui.Image;
    public dog_lv_4: eui.Image;
    public dog_lv_5: eui.Image;
    public dog_lv_6: eui.Image;
    public dog_lv_7: eui.Image;
    public dog_lv_8: eui.Image;
    public dog_lv_9: eui.Image;
    public dog_lv_10: eui.Image;
    public closeBtn: eui.Button;
    public petLvText: eui.Label;



    public get skinKey() { return 'NewPetPanel' }
    public get groupName() { return 'newpet_panel' }

    NewPetData

    constructor(data: any) {
        super(data);
        this.NewPetData = data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
    onTouchTap() {
        super.onTouchTap()
        if (this.NewPetData.callBack) {
            this.NewPetData.callBack(false);
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn1.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.closeBtn2.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    private onLoad(): void {
        this.noprize.visible = false;
        this.prize.visible = false;

        for (let i = 1; i <= 10; i++) {
            this["dog_lv_" + i].visible = false
        }
        if (this.NewPetData.lv) {
            this["dog_lv_" + this.NewPetData.lv].visible = true;
            this.petLvText.text="" + DataConversion.dogLvIndex[this.NewPetData.lv - 1] + DataConversion.dogLvLists[this.NewPetData.lv - 1]
            //console.log("" + DataConversion.dogLvIndex[this.NewPetData.lv - 1] + DataConversion.dogLvLists[this.NewPetData.lv - 1])
        }
        if (this.NewPetData.prize) {
            this.prize.visible = true;
            this.prizeImg.source = this.NewPetData.prize.prizeImgUrl
        } else {
            this.noprize.visible = true;
        }

        this["loop_light"].play(0)
        this["loop_light"].items.forEach((item) => {
            item.tween.loop = true;
        })

        this["loop_star"].play(0)
        this["loop_star"].items.forEach((item) => {
            item.tween.loop = true;
        })
        // this.jlText.text = this.NewPetData.text;
    }


}