import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class TimesTipsPanel extends Panel {

    public share1:eui.Group;
    public share2:eui.Group;
    public get skinKey() { return 'TimeTipsPanel' }
    //public get groupName() { return 'timetips_panel'}
    private mada;
    constructor(data?:any){
        super(data);
        this.mada = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
    }

    private onLoad():void{
        if(this.mada && this.mada.type == 1)
        {
            this.share1.visible = false;
            this.share2.visible = true;
        }
        else
        {
            this.share1.visible = true;
            this.share2.visible = false;
        }
    }

    private onTap1():void{
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}