import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleType } from '../../libs/tc/enum/ModuleType';
import { ModuleTypes } from '../types/sceneTypes';
import { TaskItemComponent } from "../components/TaskItemComponent";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
export default class TaskPanel extends Panel {
    public ruleLb:eui.Label;
    public closeBtn:eui.Button;
    public taskInfo:eui.Label;

    public taslDataGroup:eui.Group;
    public closeTaskInfoBtn:eui.Button;
    public taskInfoGroup:eui.Group;
    public taskLb:eui.Label;

    public taskBg:eui.Image;
    private bgtexture:egret.Texture;
    public taskInfoBg:eui.Image;
    private taskInfoTexture:egret.Texture;
    public get skinKey() { return 'TaskPanel' }
    public get groupName() { return 'task_panel' }

    constructor(data: any) {
        super(data);
    }
    protected async preLoadRes() {
        this.bgtexture = await RES.getResAsync('taskBg_jpg');
        this.taskInfoTexture = await RES.getResAsync('ruleBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        //this.pMask.visible = false;
        this.taskBg.texture = this.bgtexture;
        this.taskInfoBg.texture = this.taskInfoTexture;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.taskInfo.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickTaskInfo,this);
        this.closeTaskInfoBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onCloseTaskInfo,this);

        
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.taskInfo.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickTaskInfo,this);
        this.closeTaskInfoBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onCloseTaskInfo,this);
    }

    private onLoad():void{
        this.taskInfoGroup.visible = false;
        NetManager.ins.getTaskList((success,result) => {
            if(!result)
            {
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                this.hidePanel();
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }
            }else{
                this.handleTaskData(result);
            }
        })
    }
    private handleTaskData(result){
        for(let i=0; i<result.data.length; i++)
        {
            let data = result.data[i];
            let dItem = new TaskItemComponent(data, this.onClickBack.bind(this));
            this.taslDataGroup.addChild(dItem);
            dItem.x = 0;
            dItem.y = i * (140 + 5);
        }
    }
    private onClickBack(taskType){
        //	邀请好友助力
        if(taskType == 3)
        {
            PanelCtrl.instance.show(ModuleTypes.INVITATION_PANEL);
        }
        //	帮好友收幸福值
        if(taskType == 4)
        {
            PanelCtrl.instance.show(ModuleTypes.FRIEDN_KITCHEN_PANEL);
        } 
        this.hidePanel();
        GDispatcher.dispatchEvent('closeTaskPanel');
    }
    private onClickTaskInfo(){
        this.taskInfoGroup.visible = true;
        this.taskLb.stroke = 0;
        this.taskLb.text = window['taskRule'];
    }
    private onTap_closeBtn(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        this.hidePanel();
        GDispatcher.dispatchEvent('closeTaskPanel');
    }
    private onCloseTaskInfo(){
        this.taskInfoGroup.visible = false;
    }

}