
import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import SvgaCtrl from "../ctrls/svgaCtrl";
import { NetNameNew } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { GTime } from '../../libs/tc/util/GTime';
import { TimeFormat } from '../../libs/tc/enum/TimeFormat';
import { LotteryType } from '../../libs/tw/enum/LotteryType';
import { MyHeartItem } from "../components/MyHeartItem";
import { BubbleItem } from "../components/BubbleItem";
import { buttonTypes } from './../types/buttonTypes';
import { GetBuriedData } from "../GetBuriedData";

export default class StartScene extends Scene {

    public npcBtn:eui.Button;
    public ruleBtn:eui.Button;
    public taskBtn:eui.Button;
    public prizeBtn:eui.Button;
    public dressBtn:eui.Button;
    public FriendKitchenBtn:eui.Button;
    public studyBtn:eui.Button;
    public biscuitsBtn:eui.Button;

    public startSceneBg:eui.Image;
    public startBar:eui.Image;

    public modelGroup:eui.Group;
    public heartGroup:eui.Group;

    //饼干数量
    public biscuitsCount:eui.Label;
    //幸福值
    public happinessLb:eui.Label;
    //幸福值进度条
    public pBar:eui.ProgressBar;
    //倒计时
    public timeLab:eui.Label;
    public timelabHint:eui.Label;

    private _shape:egret.Shape;

    //状态
    private stateNormalViolet:SVGA.EgretMovieClip;
    private stateNormalGreen:SVGA.EgretMovieClip;
    private stateNormalRed:SVGA.EgretMovieClip;
    private stateDozeGreen:SVGA.EgretMovieClip;
    private stateDozeRed:SVGA.EgretMovieClip;
    private stateDozeViolet:SVGA.EgretMovieClip;
    private stateStudyGreen:SVGA.EgretMovieClip;
    private stateStudyRed:SVGA.EgretMovieClip;
    private stateStudyViolet:SVGA.EgretMovieClip;
    private stateMakeGreen:SVGA.EgretMovieClip;
    private stateMakeRed:SVGA.EgretMovieClip;
    private stateMakeViolet:SVGA.EgretMovieClip;

    private playState:any;
    private mData;
    

    private scene1:egret.Texture;
    private scene2:egret.Texture;

    private timeContinued = 0;
    private intervalID;
     //滤镜
    private colorFlilter;

    private timer:egret.Timer;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    private curHappinessValue:number = 0;
    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickRule,this);
        this.taskBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickTask,this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickPrize,this);
        this.dressBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickDress,this);
        this.FriendKitchenBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickFriendKitchen,this);
        this.studyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickStudy,this);
        this.biscuitsBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBiscuits,this);
        //this.npcBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClicknpcBtn,this);

        GDispatcher.addEvent('changeSuit', this.changeSuit, this);

        GDispatcher.addEvent('Exchange_InitDa', this.changeSuit, this);
    }

    removeEvents() {
        super.removeEvents();
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickRule,this);
        this.taskBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickTask,this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickPrize,this);
        this.dressBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickDress,this);
        this.FriendKitchenBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickFriendKitchen,this);
        this.studyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickStudy,this);
        this.biscuitsBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBiscuits,this);
        //this.npcBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClicknpcBtn,this);
        
        GDispatcher.removeEvent('changeSuit', this.changeSuit, this);
        GDispatcher.removeEvent('Exchange_InitDa', this.changeSuit, this);
    }

    start(data?) {
        super.start(data);
        this.mData = data;
        this.percentHeight = 100;
    }

    protected async preLoadRes() {
        this.scene1 =await RES.getResAsync('stratBg1_jpg');
        this.scene2 =await RES.getResAsync('stratBg2_jpg');

        this.stateNormalViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalViolet.svga') as SVGA.EgretMovieClip;
        this.stateNormalGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalGreen.svga') as SVGA.EgretMovieClip;
        this.stateNormalRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalRed.svga') as SVGA.EgretMovieClip;
        this.stateDozeGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeGreen.svga') as SVGA.EgretMovieClip;
        this.stateDozeRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeRed.svga') as SVGA.EgretMovieClip;
        this.stateDozeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeViolet.svga') as SVGA.EgretMovieClip;
        this.stateStudyGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyGreen.svga') as SVGA.EgretMovieClip;
        this.stateStudyRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyRed.svga') as SVGA.EgretMovieClip;
        this.stateStudyViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyViolet.svga') as SVGA.EgretMovieClip;
        this.stateMakeGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeGreen.svga') as SVGA.EgretMovieClip;
        this.stateMakeRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeRed.svga') as SVGA.EgretMovieClip;
        this.stateMakeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeViolet.svga') as SVGA.EgretMovieClip;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
      
    }
    private onLoad(): void {
        var colorMatrix = [
            0.3,0.6,0,0,0,
            0.3,0.6,0,0,0,
            0.3,0.6,0,0,0,
            0,0,0,1,0
        ];
        this.colorFlilter = new egret.ColorMatrixFilter(colorMatrix);
        this.exchangeInitDa();
        window['newUserGuide'] = false;
       
        //this.initData();
    }
    private exchangeInitDa(){
        if(this.mData && this.mData.data)
        {
            this.initData();
        }
        else{
            this.initUI();
            this.initPrize();
        }
        NetManager.ins.showLog(GetBuriedData(1));
    }
    private initData(){
        NetManager.ins.getInformation((success,result) => {
            console.log('数据-',DataManager.ins.getData('getIndex').data);
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }

            this.initUI();
            this.initPrize();
        })
    }
    private initUI():void{
        let suitId = DataManager.ins.getData('getIndex').data.suitId;
        let sceneId = DataManager.ins.getData('getIndex').data.sceneId;
        this.initPlayState(suitId?suitId:'suit_1');
        this.playSVGA(this.playState.normal);
        this.setSceneBg(sceneId?sceneId:'scene_1');
        this.setStudyBar();
        //饼干数
        this.biscuitsCount.text = DataManager.ins.getData('getIndex').data.cookies + '块';
        let happinessValue = DataManager.ins.getData('getIndex').data.happinessValue;
        this.curHappinessValue = happinessValue;
        this.setHappinessValue(happinessValue,false);
        if(!DataManager.ins.getData('getIndex').data.canReceive)
        {
            let nextReceiveTime = DataManager.ins.getData('getIndex').data.nextReceiveTime;
            let currentTime = DataManager.ins.getData('getIndex').data.currentTime;
            this.initReceiveTime(nextReceiveTime - currentTime);
        }
        else
        {
            this.initReceiveTime(0)
            this.setStudyBarGraphics(0);
        }
    }

    private initPrize(){
        let dailyAwardType = DataManager.ins.getData('getIndex').data.dailyAwardType;
        let dailyAward = DataManager.ins.getData('getIndex').data.dailyAward;
        let remainDays = DataManager.ins.getData('getIndex').data.remainDays;
        let awardString = '今日可获得' + dailyAward + '点幸福值';
        if(dailyAwardType == 1)
        {
            //window['dailyAwardType'] = 0;
            NetManager.ins.showLog(GetBuriedData(2));
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.KNOW_BTN,
                                                            data:['恭喜你，签到成功',awardString],
                                                            sign:'再连续签到' + remainDays + '天可获得额外奖励啦',
                                                            callBack:function(){console.log("点击返回1")}});
                                                            
        }
        if(dailyAwardType == 2)
        {
            //window['dailyAwardType'] = 0;
            NetManager.ins.showLog(GetBuriedData(3));
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.KNOW_BTN,
                                                            data:['恭喜你，已连续签到7天',awardString],
                                                            callBack:function(){console.log("点击返回")}});
        }
        let helpReceive = DataManager.ins.getData('getIndex').data.helpReceive;
        let helpNickname = DataManager.ins.getData('getIndex').data.helpNickname;
        if(!helpNickname)
        {
            helpNickname = '小熊厨房好友';
        }
        let helpReceiveTime = DataManager.ins.getData('getIndex').data.helpReceiveTime;
        let needHelpReceivePopup = DataManager.ins.getData('getIndex').data.needHelpReceivePopup;
        if(helpReceive && needHelpReceivePopup)
        {
            //window['helpReceive'] = false;
            //window['needHelpReceivePopup'] = false;
            let currentTime = DataManager.ins.getData('getIndex').data.currentTime;
            //let helpNickname = window['helpNickname'];
            //let helpReceiveTime = window['helpReceiveTime'];
            let curTimeDay = new Date(currentTime);
            let helpReceiveTimeDay = new Date(helpReceiveTime);
            let hintLab = '';
            if(curTimeDay.getDate() == helpReceiveTimeDay.getDate())
            {
                hintLab = helpNickname + '在今天帮你收了幸福值';
            }else{
                hintLab = helpNickname + '在' +(helpReceiveTimeDay.getMonth() +1) +'月'+ (helpReceiveTimeDay.getDate()) + '日' + '帮你收了幸福值';
            }
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.KNOW_BTN,
                                                            data:[hintLab],
                                                            callBack:function(){console.log("点击返回2")}});
        }
    }
    getlocalStorageData() {
        let currentTime = DataManager.ins.getData('getIndex').data.currentTime;
        const date = new Date(currentTime);
        const str = `${date.getFullYear()}-${date.getMonth()}-${date.getDate()}`
        const result = localStorage.getItem(str);
        if (!result) return 0;
        return parseInt(result);
    }
    setlocalStorageData() {
        let currentTime = DataManager.ins.getData('getIndex').data.currentTime;
        const date = new Date(currentTime);
        const str = `${date.getFullYear()}-${date.getMonth()}-${date.getDate()}`
        localStorage.setItem(str, (this.getlocalStorageData() + 1) + '');
    }

    private setSceneBg(sceneID){
        if(sceneID == 'scene_1')
        {
            this.startSceneBg.texture = this.scene1;
        }
        if(sceneID == 'scene_2')
        {
            this.startSceneBg.texture = this.scene2;
        }
    }
    //设置 模型 svga 播放状态
    private initPlayState(suitID){
        switch(suitID)
        {
            case 'suit_1':
                this.playState = {'normal':this.stateNormalViolet,
                                  'doze':this.stateDozeViolet,
                                  'study':this.stateStudyViolet,
                                  'make':this.stateMakeViolet}
                break;
            case 'suit_2':
                this.playState = {'normal':this.stateNormalGreen,
                                    'doze':this.stateDozeGreen,
                                    'study':this.stateStudyGreen,
                                    'make':this.stateMakeGreen}
                break;
            case 'suit_3':
                this.playState = {'normal':this.stateNormalRed,
                                    'doze':this.stateDozeRed,
                                    'study':this.stateStudyRed,
                                    'make':this.stateMakeRed}
                break;
        }
        
    }
    private playSVGA(action:SVGA.EgretMovieClip,callback?: Function){
        this['modelGroup'].removeChildren();
        this['modelGroup'].addChild(action);
        if(callback)
        {
            action.startAniRange(1,action.totalFrames,1,callback.bind(this));
        }
        else
        {
            action.play();
        }
    }
    //设置 幸福值
    private setHappinessValue(happinessValue,isMake:boolean){
        let value = 0;
        if(happinessValue < 100){
            value = happinessValue;
            this.playSVGA(this.playState.normal);
        }else{
            if(isMake)
            {
                this.makeBiscuits();
            }else{
                value = (happinessValue % 100);
                this.initBiscuitsFloat(happinessValue);
                this.playSVGA(this.playState.normal);
            }
        }
        this.happinessLb.text = value + '';
        this.pBar.value = value;
    }
    //制作饼干
    private makeBiscuits(){
        this.playSVGA(this.playState.make,()=>{
            this.setHappinessValue(this.curHappinessValue,false);
            this.playSVGA(this.playState.normal);
        });
    }
    //设置 悬浮的饼干
    private initBiscuitsFloat(happinessValue){
        let biscuitsFloat = Math.floor((happinessValue/100));
        let floatCount = this.getCurrentFloatCount();
        //console.log('节点数',biscuitsFloat);
        if(biscuitsFloat < 1) 
        {
            return;
        }
        let biscuitsFloatNew = biscuitsFloat - floatCount;
        if(biscuitsFloatNew <= 0)
        {
            return;
        }
        let count = 1;
        for(let i = 1; i < 6; i++)
        {
            let node:eui.Group = this['bubbleItemGroup' + i];
            if(node.numChildren < 1)
            {
                if(count > biscuitsFloatNew)
                {
                    return;
                }
                count++
                let mybiscuits = new BubbleItem(this.biscuitsBtn.x,this.biscuitsBtn.y,function(){this.collectBiscuits()}.bind(this));
                node.addChild(mybiscuits);
                mybiscuits.x = 0;
                mybiscuits.y = 0;
            }
        }
    }
    private getCurrentFloatCount(){
        let count = 0;
        for(let i = 1; i < 6; i++)
        {
            let node:eui.Group = this['bubbleItemGroup' + i];
            if(node.numChildren >= 1)
            {
                count ++;
            }
        }
        return count;
    }
    //学习按钮的遮罩
    private setStudyBar(){
        let studyGroup:eui.Group = this['studyGroup'];
        if(studyGroup.getChildByName('shape'))
        {
            studyGroup.removeChild(studyGroup.getChildByName('shape'))
        }
        this._shape = new egret.Shape();
        studyGroup.addChild(this._shape);
        this._shape.name = 'shape'
        this._shape.x = 87.5;
        this._shape.y = 87.5;
        this._shape.rotation = -90;
        this.startBar.mask = this._shape;
    }
    //时间倒计时
    private initReceiveTime(cutDownTime){
        console.log('倒计时',cutDownTime);
        if(cutDownTime <= 0)
        {
            this.studyBtn.enabled = true;
            this.studyBtn.filters = null;
            this.setStudyBarGraphics(0);
            this.timeLab.visible = false;
            this.timelabHint.visible = false;
            //暂定2分打一次哈欠
            this.timer = new egret.Timer(120000,0);
            this.timer.addEventListener(egret.TimerEvent.TIMER, this.playAlternateState, this);
            this.timer.start();
            
        }
        else
        {
            this.timeLab.visible = true;
            this.timelabHint.visible = true;
            this.setStudyBarGraphics(cutDownTime);
            this.studyBtn.enabled = false;
            this.studyBtn.filters = [this.colorFlilter];
            let startTime = Math.floor(cutDownTime / 1000);
            this.timeLab.text = GTime.formatTime(startTime, TimeFormat.HMS, false,[':',':','','']);
            egret.Tween.get(this.timeLab, {loop:true}).wait(1000).call(() => {
                startTime --;
                this.timeLab.text = GTime.formatTime(startTime, TimeFormat.HMS, false,[':',':','','']);
                this.setStudyBarGraphics(startTime*1000);
                if(startTime <= 0){
                    this.studyBtn.enabled = true;
                    this.studyBtn.filters = null;
                    egret.Tween.removeTweens(this.timeLab);

                    this.timeLab.visible = false;
                    this.timelabHint.visible = false;

                    //暂定2分打一次哈欠
                    this.timer = new egret.Timer(120000,0);
                    this.timer.addEventListener(egret.TimerEvent.TIMER, this.playAlternateState, this);
                    this.timer.start();

                }
            });
        }
    }
    //交替状态
    private playAlternateState(){
        console.log('计时器',new Date());
        this.playSVGA(this.playState.doze,()=>{this.playSVGA(this.playState.normal)})
    }

    private setStudyBarGraphics(cutDownTime){
        let angle =  ((86400000 - cutDownTime)/86400000)*360;
        this.changeGraphics(angle);
    }
    //学习 进度条
    private changeGraphics(angle): void {
        this._shape.graphics.beginFill(0x00ffff, 1);
        this._shape.graphics.moveTo(0, 0);
        this._shape.graphics.lineTo(200, 0);
        this._shape.graphics.drawArc(0, 0, 100, 0, (angle * Math.PI / 180), false);
        this._shape.graphics.lineTo(0, 0);
        this._shape.graphics.endFill();
    }
    //养成攻略
    private onClickRule():void{
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    //每日任务
    private onClickTask():void{
        PanelCtrl.instance.btnDelay(this.taskBtn);
        PanelCtrl.instance.show(ModuleTypes.TASK_PANEL);
    }
    //我的奖品
    private onClickPrize():void{
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        window.location.href = window['prizeUel'] ? window['prizeUel'] : '//activity.m.duiba.com.cn/projectx/pe5a48ba7/ff0f29f27.html';
    } 
    //我的装扮
    private onClickDress():void{
        PanelCtrl.instance.btnDelay(this.dressBtn);
        PanelCtrl.instance.show(ModuleTypes.DRESS_PANEL);
    }  
    //好友厨房
    private onClickFriendKitchen():void{
        PanelCtrl.instance.btnDelay(this.FriendKitchenBtn);
        PanelCtrl.instance.show(ModuleTypes.FRIEDN_KITCHEN_PANEL);
    } 
    //学厨艺
    private onClickStudy():void{
        PanelCtrl.instance.btnDelay(this.studyBtn);
        this.collectHappiness();
    } 
    private playStudyState(happinessValue){
        this.studyBtn.enabled = false;
        this.studyBtn.filters = [this.colorFlilter];
        if(this.timer)
        {
            this.timer.stop();
            this.timer.removeEventListener(egret.TimerEvent.TIMER, this.playAlternateState, this);
        }
        this.setStudyBar();
        this.initReceiveTime(86400000);
        this.playSVGA(this.playState.study);
        this.intervalID = setInterval(function(){this.moveHerat()}.bind(this),200);
        this.addHappiness(10,function(){
            let collectSetInterval = setInterval(function(){
                clearInterval(collectSetInterval);
                if((this.curHappinessValue % 100 + 10) >= 100)
                {
                    this.curHappinessValue = happinessValue;
                    this.setHappinessValue(happinessValue,true);
                }else{
                    this.curHappinessValue = happinessValue;
                    this.setHappinessValue(happinessValue,false);
                }
            }.bind(this),1400);
        }.bind(this));
        console.log('学习');
    }
    
    //饼干
    private onClickBiscuits():void{
        PanelCtrl.instance.btnDelay(this.biscuitsBtn);
        PanelCtrl.instance.show(ModuleTypes.EXCHANGE_PANLE)
    } 
    
    private changeSuit(){
        this.initData();
    }
    //收取幸福值
    private collectHappiness(){
        NetManager.ins.getHappiness((success,result)=>{
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            this.playStudyState(result.data.happinessValue);
        })
    }
    //收取饼干
    private collectBiscuits(){
        console.log('收取饼干');
        NetManager.ins.getReceive((success,result)=>{
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            this.curHappinessValue = result.data.happinessValue;
            this.setHappinessValue(result.data.happinessValue,false);
            this.biscuitsCount.text = result.data.cookies + '块';
            this.updataData();
        })
        egret.Tween.get(this.biscuitsBtn,{loop:false})
        .to({scaleX:1.2,scaleY:1.2}, 100)
        .to({scaleX:1,scaleY:1}, 100)
    }
    private addHappiness(vaule:number,callback?: Function){
        let initVaule = 0;
        egret.Tween.get(this.happinessLb, {loop:true}).wait(vaule/1000).call(() => {
            initVaule ++;
            let curValue = (this.curHappinessValue % 100) + initVaule;
            this.happinessLb.text = curValue+'';
            if(initVaule >= vaule){
                callback();
                egret.Tween.removeTweens(this.happinessLb); 
            }
        });
    }
    private moveHerat(){
        if(this.timeContinued >= 800)
        {
            clearInterval(this.intervalID);
            return;
        }
        this.timeContinued += 200;
        let dItem = new MyHeartItem();
        this.heartGroup.addChild(dItem);
        dItem.x = 0;
        dItem.y = 0;
    }
    private updataData(){
        NetManager.ins.getInformation((success,result) => {
            console.log('数据-',DataManager.ins.getData('getIndex').data);
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {   
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }

        })
    }
    private onClicknpcBtn(){
        window.location.href = '/faq/index?dbnewopen';
    }
    //获取我的奖品
    private gotoRecord():string{
        let recordUrl: string;
        let oaId: number;
        if (DataManager.ins.customCfgData) {
            oaId = DataManager.ins.customCfgData.oaId;
            recordUrl = DataManager.ins.customCfgData.recordUrl;
        } else {
            oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
            recordUrl = window['recordUrl'];
        }

        if(recordUrl.indexOf('?') != -1){
            recordUrl += '&origins=' + oaId + '00';
        }else{
            recordUrl += '?origins=' + oaId + '00';
        } 
        return recordUrl;
    }

}
