
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleType } from "../../libs/tc/enum/ModuleType";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class SharePanel extends Panel {

 
    private friendBtn:eui.Button;
    private weChatBtn:eui.Button;
  

    // private tfArr:egret.TextField[];

    public get skinKey() { return 'SharePanel' }
	public get groupName() { return 'share_panel'}
    
    constructor(data?){
        super(data);
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.friendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFriend, this);
        this.weChatBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickWeChat, this);
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.closePanel, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.friendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFriend, this);
        this.weChatBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickWeChat, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.closePanel, this);
    }

    private onLoad():void{
        this.showAct();
    }
    private onClickWeChat(){
        console.log("微信好友分享");
        //this.hidePanel();
        this.shareCallBack(1);
    }
    private onClickFriend(){
        console.log("微信朋友圈分享");
        //this.hidePanel();
        this.shareCallBack(2);
    }
    private shareCallBack(type){
        if(window['isdebug'])
        {
            NetManager.ins.getInformation((success,result) => {
                if(success && result.data)
                {
                    let sessionSettings = result.data.sessionSettings.split(',');
                    let endTimeDay = result.data.sessionEndTime.split('-');
                    let date = new Date(endTimeDay[0],endTimeDay[1],endTimeDay[2]).getTime();
                    let endTime  =  date + sessionSettings[sessionSettings.length - 1]*3600000 + result.data.sessionDuration;
                    if(result.data.timestamp < endTime)
                    {
                        NetManager.ins.addTimeShare((success,result) => {
                            if(success && result)
                            {
                         
                                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2});
                            }
                            else
                            {
                                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
                            }
                        });
                    }
                } 
            })
            return ;
        }

        let shareType = type + '';
        window['setupWebViewJavascriptBridge'](function (bridge) {

            console.log("成功进入分享"+bridge);
            bridge.callHandler('FunctionManagement', {
                                'type':'ArouseShare',
                                'param':{
                                        'title':'百万红包雨，限时疯抢中',
                                        'content':"壹品仓福利大派送，等你来捞！",
                                        'img':'https://yun.duiba.com.cn/db_games/activity/ypc_hongbaoyu/shareImg/shareImg.jpg',
                                        'link_url':'http://api.gongchangtemai.com/api/v1/duiba/login?redirect_url=https%3A%2F%2Factivity.m.duiba.com.cn%2Fprojectx%2Fpa9f8a92f%2Findex.html%3FshareCode%3D123',
                                        'shareType':shareType,}},
                                function(response) {
                                    response =  JSON.parse(response);
                                    console.log("回调成功",response);
                                    
                                    if(response.success && response.data.shareResult == 1)
                                    {
                                        console.log('分享返回成功');
                                        NetManager.ins.getInformation((success,result) => {
                                            if(success && result.data)
                                            {
                                                let sessionSettings = result.data.sessionSettings.split(',');
                                                let endTimeDay = result.data.sessionEndTime.split('-');
                                                let date = new Date(endTimeDay[0],endTimeDay[1],endTimeDay[2]).getTime();
                                                let endTime  =  date + sessionSettings[sessionSettings.length - 1]*3600000 + result.data.sessionDuration;
                                                if(result.data.timestamp < endTime)
                                                {
                                                    NetManager.ins.addTimeShare((success,resultShare) => {
                                                        if(success && resultShare)
                                                        {
                                                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2});
                                                        }
                                                        else
                                                        {
                                                            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
                                                            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                                                        }
                                                    });
                                                }
                                            } 
                                        })
                                    }
                                    else
                                    {
                                        console.log('分享失败');
                                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享失败'});
                                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                                    }
                                });
          }.bind(this));
    }

    private closePanel(e:egret.TouchEvent){
        console.log("取消分享");
        if(this.friendBtn != e.target && this.weChatBtn != e.target)
        {
            this.hidePanel();
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'取消分享'});
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        }
    }
}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}