
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from './../types/sceneTypes';
import { buttonTypes } from './../types/buttonTypes';
export default class MsgPanel extends Panel {
    private mData:any;

    public closeBtn:eui.Button;
    public getPrizeBtn:eui.Button;
    public joinInBtn:eui.Button;
    public knowBtn:eui.Button;

    public titile:eui.Label;
    public content1:eui.Label;
    public content2:eui.Label;
    public signLb:eui.Label;
    
    public popup:eui.Image;
    private bgtexture:egret.Texture;
    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }
    protected async preLoadRes() {
		
		this.bgtexture = await RES.getResAsync('msgBg_jpg');

        return new Promise(function (resolve, reject) {
            resolve();
        });
	}
    onSkinComplete():void{
        super.onSkinComplete();
        this.popup.texture = this.bgtexture;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }
    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.getPrizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onJoinApp,this);
        this.joinInBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onJoinApp,this);
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBtn,this);
    }
    removeEvents():void{
        super.removeEvents();
        if(this.getPrizeBtn)
        {
            this.getPrizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onJoinApp,this);
        }
        if(this.joinInBtn)
        {
            this.joinInBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onJoinApp,this);
        }
        if(this.knowBtn)
        {
            this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBtn,this);
        }
       
    }

    private onLoad():void{
        // if(this.mData && this.mData.callBack)
        // {
        //     this.mData.callBack();
        // }
        this.initUI();
    }
    private initUI(){
        this.getPrizeBtn.visible = false;
        this.joinInBtn.visible = false;
        this.knowBtn.visible = false;
        console.log('弹窗数据',this.mData);
        if(this.mData)
        {
            this.setButtonType();    
        }
        if(this.mData && this.mData.data && this.mData.data.length > 0)
        {
           
            this.setWordsUI();
        }
        if(this.mData && this.mData.sign)
        {
            this.signLb.text = this.mData.sign;
            this.signLb.visible = true;
        }
    }
    private setButtonType(){
        switch(this.mData.buttonType)
        {
            case buttonTypes.GETPRIZE_BTN:
                this.getPrizeBtn.visible = true;
                break;
            case buttonTypes.JOININ_BTN:
                this.joinInBtn.visible = true;
                break;
            case buttonTypes.KNOW_BTN:
                this.knowBtn.visible = true;
                break;
        }
    }
    private setWordsUI(){
        if(this.mData.data.length == 1)
        {
           
            this.content1.text = this.mData.data[0];
            this.content1.visible = true;
            return;
        }
        if(this.mData.data.length == 2)
        {
            this.titile.text = this.mData.data[0];
            this.content1.text = this.mData.data[1];
            this.titile.visible = true;
            this.content1.visible = true;
            return;
        }
        if(this.mData.data.length == 3)
        {
            this.titile.text = this.mData.data[0];
            this.content1.text = this.mData.data[1];
            this.content2.text = this.mData.data[2];
            this.titile.visible = true;
            this.content1.visible = true;
            this.content2.visible = true;
            return;
        }
    }
    private onClickBtn(){
        this.hidePanel();
        if(this.mData && this.mData.callBack)
        {
            this.mData.callBack();
        } 
    }
    private onTap(e:egret.TouchEvent):void{
        
    }
    private onJoinApp(){
        window.location.href = window['callAppLink']?window['callAppLink']:('https://h5.bestpay.com.cn/subapps/openBestpay/index.html?isHome=true&url=' + window.location.href);
    }
}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}