import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import SceneCtrl from "../ctrls/sceneCtrl";
import SvgaCtrl from "../ctrls/svgaCtrl";
import { DataManager } from './../../libs/tw/manager/DataManager';

export default class LoadingScene extends Scene {
	public pBar:eui.ProgressBar;
	public loadSceneBg:eui.Image;
	private lastVal:number;

	private bgtexture:egret.Texture;
	private xSvga:SVGA.EgretMovieClip;
	public get skinKey() { return 'LoadingScene' }
	public get groupName() { return 'loading_scene'}

	constructor(data?) {
		super(data);
	}

	initEvents() {
		GDispatcher.addEvent('progress', this.setProgress, this);
	}

	removeEvents() {
		GDispatcher.removeEvent('progress', this.setProgress, this);
	}
	protected onSkinComplete(): void {
		super.onSkinComplete();
		this.loadSceneBg.texture = this.bgtexture;
		this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

	start(data?) {
		this.percentHeight = 100;
		this.lastVal = 0;
	}
	protected async preLoadRes() {
		this.xSvga = await SvgaCtrl.instance.getSvga('resource/assets/svga/loading.svga') as SVGA.EgretMovieClip;

		this.bgtexture = await RES.getResAsync('loadSceneBg_jpg');

        return new Promise(function (resolve, reject) {
            resolve();
        });
	}
	//<script  src="https://h5.bestpay.com.cn/common/js/bestpay-html5-3.0.js"></script>
	protected onLoad(): void {
		
		
		this['svga'].addChild(this.xSvga);
		this.xSvga.y -= 280;
		this.xSvga.play();
	}
	private setProgress(data):void{
		let v = data[0];
		this.pBar.value = v;
		setTimeout(() => {
			if(v >= 100){
				this.doMainScene()
			}
		}, 500);
		this.lastVal = v;
	}

	doMainScene(){
		if(DataManager.ins.getData('getIndex').data.newUserGuide) 
		{
			
			SceneCtrl.instance.change(ModuleTypes.GUIDE_SCENE);
		}
		else
		{
			//window['newUserGuide'] = false;
			SceneCtrl.instance.change(ModuleTypes.START_SCENE);
		}
	}
}