
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { AssistanceItem } from "../components/AssistanceItem";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import SceneCtrl from "../ctrls/sceneCtrl";


export default class InvitationPanel extends Panel {


    public invitationBtn:eui.Button;
    public shareGroup:eui.Group;
    public content1:eui.Label;
    public content2:eui.Label;
    public friendBackBtn:eui.Button;
    public bg:eui.Image;
    private bgtexture:egret.Texture;
    public shareBg:eui.Image;
    private shareBgTexture:egret.Texture;
    public get skinKey() { return 'InvitationPanel' }
    public get groupName() { return 'invitation_panel' }

    constructor(data: any) {
        super(data);
    }

    protected async preLoadRes() {
        this.bgtexture = await RES.getResAsync('invitationBg_jpg');
        this.shareBgTexture = await RES.getResAsync('msgBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.bg.texture = this.bgtexture;
        this.shareBg.texture = this.shareBgTexture;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.invitationBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickInvitation,this);
        this.friendBackBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBack,this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.invitationBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickInvitation,this);
        this.friendBackBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBack,this);
    }

    private onLoad():void{
        this.initUI();
    }

    private initUI(){
        this.shareGroup.visible = false;

    }
    private share(callBack:Function,shareCode,uid){
        let shareUrl = window['shareUrlLink']?window['shareUrlLink']:"https://activity.m.duiba.com.cn/projectx/pe3b02e09/f455b8799.html";
        if(shareCode){
            shareUrl = this.setShareCode(shareUrl,'shareCode',shareCode);
        }
        if(uid){
            shareUrl = this.setShareCode(shareUrl,'uid',uid);
        }
        console.log('分享地址',shareUrl);
        if(window['isDebug']){
            window.location.href = shareUrl;
        }else{
            window['BestpayHtml5'].Other.share(
                {
                    title: window['shareData'].title, //标题
                    text: window['shareData'].desc, //内容
                    imageUrl: window['shareData'].imgUrl, //图片地址
                    imageData: "",//图片base64(不需要加前缀)
                    linkUrl:shareUrl, //页面链接
                    type:"",//分享类型:yixin 易信,yixinCircle 易信朋友圈,weixin 微信,weixinTimeline 微信朋友圈,sinaWeibo 新浪微博,qqFriend QQ好友,qZone qq空间,email 邮件,sms  短信
                    contentType: "link"//link :默认链接方式分享;image:图片方式分享  
                  }
                  , function (obj) {
                      if(callBack)
                      {
                          this.callBack();
                      }
                    alert("success" + JSON.stringify(obj))
                  }, function (obj) {
                        if(callBack)
                        {
                            this.callBack();
                        }
                    alert("fail" + JSON.stringify(obj))
                  }, function (obj) {
                        if(callBack)
                        {
                            this.callBack();
                        }
                    alert("cancel"+ JSON.stringify(obj))
                  }
            )
        }
    }
    //1名好友成功助力可获得20幸福值，当天做多获得60幸福值
    private onClickInvitation(){
        NetManager.ins.genInvite((success,result)=>{
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            console.log('分享码',result.data);
            NetManager.ins.getProjectUserInfo((success,resultInfo)=>{
                if(!resultInfo)
                {
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
                if(!success)
                {
                    if(!resultInfo.code){
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                        return;
                    }else if(resultInfo.code == '100001'){
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                        return;
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                        return;
                    }
                }
                console.log('uid',resultInfo.data.partnerUserId);
                this.share(function(){
                    this.content1.text = '1名好友成功助力可获得20幸福值';
                    this.content2.text = '当天做多获得60幸福值';
                    this.shareGroup.visible = true;
                }.bind(this),result.data,resultInfo.data.partnerUserId)
            })
        })
    }
    private setShareCode(url, arg, arg_val){
        let pattern = arg + '=([^&]*)';
        let replaceText = arg + '=' + arg_val;
        if (url.match(pattern)) {
            let tmp = '/(' + arg + '=)([^&]*)/gi';
            tmp = url.replace(eval(tmp), replaceText);
            return tmp;
        } else {
            if (url.match('[\?]')) {
                return url + '&' + replaceText;
            } else {
                return url + '?' + replaceText;
            }
        }
    }
    private onClickBack(){
        PanelCtrl.instance.btnDelay(this.friendBackBtn);
        this.hidePanel();
    }
}