import Scene from "../views/Scene";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { MyHeartItem } from "../components/MyHeartItem";
import SvgaCtrl from "../ctrls/svgaCtrl";
import { DataManager } from './../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { TimeFormat } from '../../libs/tc/enum/TimeFormat';
import PanelCtrl from "../ctrls/panelCtrl";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';

export default class GuideScene extends Scene{


    public maskRect:eui.Rect;

    public guide1:eui.Group;
    public guide2:eui.Group;
    public guide3:eui.Group;
    public guide4:eui.Group;


    public guide1Btn:eui.Button;
    public guide2Btn:eui.Button;
    public guide3Btn:eui.Button;
    public guide4Btn:eui.Button;

    public happinessLb:eui.Label;
    public heartGroup:eui.Group;
    public modelGroup:eui.Group;
    public studyGroup:eui.Group;
    public startBar:eui.Image;
    public timeLab:eui.Label;

    private stateNormalViolet:SVGA.EgretMovieClip;
    private stateDozeViolet:SVGA.EgretMovieClip;
    private stateStudyViolet:SVGA.EgretMovieClip;
    private stateMakeViolet:SVGA.EgretMovieClip;

    public guideBg:eui.Image;
    private bgtexture:egret.Texture;
    
    private shape:egret.Shape;
    private timeContinued = 0;
    private intervalID;
    //幸福值进度条
    public pBar:eui.ProgressBar;
    public get skinKey() { return 'GuideScene' }
    public get groupName() { return 'guide_scene'}
    
    constructor(data?) {
		super(data);
		this.percentHeight = 100;
    }
    initEvents() {
        this.guide1Btn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep1,this);
        this.guide2Btn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep2,this);
        this.guide3Btn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep3,this);
        this.guide4Btn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep4,this);
        GDispatcher.addEvent('guideTask', this.guideTask, this);
        GDispatcher.addEvent('closeTaskPanel', this.closeTaskPanel, this);
    }
    removeEvents() {
        this.guide1Btn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep1,this);
        this.guide2Btn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep2,this);
        this.guide3Btn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep3,this);
        this.guide4Btn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.guideStep4,this);
        GDispatcher.removeEvent('guideTask', this.guideTask, this);
        GDispatcher.removeEvent('closeTaskPanel', this.closeTaskPanel, this);
    }
    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.guideBg.texture = this.bgtexture;
		this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
	protected async preLoadRes() {
        this.stateNormalViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalViolet.svga') as SVGA.EgretMovieClip;
        this.stateDozeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeViolet.svga') as SVGA.EgretMovieClip;
        this.stateStudyViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyViolet.svga') as SVGA.EgretMovieClip;
        this.stateMakeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeViolet.svga') as SVGA.EgretMovieClip;
        this.bgtexture = await RES.getResAsync('guideBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
	}
	start(data?) {
	}

	protected onLoad(): void {
        this.guide1.visible = true;
        this.guide4Btn.visible = false;
        this.setModel(1);
        this.setStudyBar();
    }

    private setStudyBar(){
        this.shape = new egret.Shape();
        this['studyGroup'].addChild(this.shape);
        this.shape.x = 87.5;
        this.shape.y = 87.5;
        this.shape.rotation = -90;
        this.startBar.mask = this.shape;
        let curDownTime = 0;
        if(!DataManager.ins.getData('getIndex').data.canReceive)
        {
            let nextReceiveTime = DataManager.ins.getData('getIndex').data.nextReceiveTime;
            let currentTime = DataManager.ins.getData('getIndex').data.currentTime;
            curDownTime = nextReceiveTime - currentTime;


            let startTime = Math.floor(curDownTime / 1000);
            this.timeLab.text = GTime.formatTime(startTime, TimeFormat.HMS, false,[':',':','','']);
            egret.Tween.get(this.timeLab, {loop:true}).wait(1000).call(() => {
                startTime --;
                this.timeLab.text = GTime.formatTime(startTime, TimeFormat.HMS, false,[':',':','','']);
                if(startTime <= 0){
                    egret.Tween.removeTweens(this.timeLab);
                }
            });
        }
        let angle =  ((86400000 - curDownTime)/86400000)*360;
        this.changeGraphics(angle);
    }

    private setModel(actionID,callback?: Function){
        let action:SVGA.EgretMovieClip;
        switch (actionID) {
            case 1:
                action = this.stateNormalViolet;
                break;
            case 2:
                action = this.stateDozeViolet;
                break;
            case 3:
                action = this.stateStudyViolet;
                break;
            case 4:
                action = this.stateMakeViolet;
                break;
            default:
                action = this.stateNormalViolet;
                break;
        }
        this.modelGroup.removeChildren();
        this.modelGroup.addChild(action);
        if(callback)
        {
            action.startAniRange(1,action.totalFrames,1,callback.bind(this));
            
        }
        else
        {
            action.play();
        }
    }
 
    private guideStep1(){
        this.maskRect.visible = false;
        this.guide1.visible = false;
        this.setModel(3);
        this.intervalID = setInterval(function(){this.moveHerat()}.bind(this),200);
        this.addHappiness(90,function(){
            let collectSetInterval = setInterval(function(){
                clearInterval(collectSetInterval);
                this.maskRect.visible = true;
                this.guide2.visible = true;
                this.setModel(1);
            }.bind(this),1000);
        }.bind(this));
    }
    
    private moveHerat(){
        if(this.timeContinued >= 1000)
        {
            clearInterval(this.intervalID);
            return;
        }
        this.timeContinued += 200;
        let dItem = new MyHeartItem();
        this.heartGroup.addChild(dItem);
        dItem.x = 0;
        dItem.y = 0;
    }
    private guideStep2(){
        this.maskRect.visible = false;
        this.guide2.visible = false;
        let intervalGuideID = setInterval(function(){clearInterval(intervalGuideID);this.maskRect.visible = true;this.guide3.visible = true;}.bind(this),1000);
        // this.setModel(3,()=>{
        //     console.log('学习完成');
        //     this.intervalID = setInterval(function(){this.moveHerat()}.bind(this),200);
        //     this.addHappiness(10,function(){
        //         this.setModel(4,()=>{
        //             console.log('制作完成');
        //             this.setModel(1);
        //             this.changeGraphics(0);
        //         });
        //     }.bind(this))
        // });
    }
    private guideStep3(){
        this.guide3.visible = false;
        this.maskRect.visible = false;
        PanelCtrl.instance.show(ModuleTypes.EXCHANGE_PANLE);
    }
    private guideTask(){
        let intervalGuideID = setInterval(function(){clearInterval(intervalGuideID);this.maskRect.visible = true;this.guide4.visible = true;this.guide4Btn.visible = true;}.bind(this),1000);
    }
    private guideStep4(){
        PanelCtrl.instance.show(ModuleTypes.TASK_PANEL);
    }
    private closeTaskPanel(){
        SceneCtrl.instance.change(ModuleTypes.START_SCENE,{data:true});
    }
        //学习 进度条
    private changeGraphics(angle): void {
        if(angle == 0)
        {
            this.startBar.visible = false;
            return;
        }
        else
        {
            this.startBar.visible = true;
        }
        this.shape.graphics.beginFill(0x00ffff, 1);
        this.shape.graphics.moveTo(0, 0);
        this.shape.graphics.lineTo(200, 0);
        this.shape.graphics.drawArc(0, 0, 100, 0, (angle * Math.PI / 180), false);
        this.shape.graphics.lineTo(0, 0);
        this.shape.graphics.endFill();
    }
    private addHappiness(vaule:number,callback?: Function){
        let initVaule = 0;
        egret.Tween.get(this.happinessLb, {loop:true}).wait(vaule/1000).call(() => {
            initVaule ++;
            this.happinessLb.text = initVaule + '';
            this.pBar.value = initVaule;
            if(initVaule >= vaule){
                callback();
                egret.Tween.removeTweens(this.happinessLb); 
            }
        });
    }
}