export default class MyImage extends eui.Image{
    public score:number;
    public iHeight:number;
    public iWidth:number;
    public type:number;

    /**
     * 检测道具碰撞
     * @param wallet
     * @return {boolean}
     */
    public hitTest(orgX:number, orgY:number, rect:eui.Group): boolean {
        //条件1 掉落单位y轴的中心点大于人物y轴的中心点
        var condition1 = Math.abs(this.y - (orgY)) < (rect.height + this.iHeight) * 0.3;
        //条件2 掉落单位y轴的中心点小于人物的y坐标+人物高度
        var condition2 = Math.abs(this.x - (orgX)) < (rect.width + this.iWidth) * 0.5;

        return condition1 && condition2;
    }
    
}