import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
export default class GameOverPanel extends Panel {


    public shareBtn:eui.Button;
    public iknowBtn:eui.Button;
    public closeBtn:eui.Button;
    public unshare:eui.Group;
    public share:eui.Group;

    private mData:any;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();

        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_iknowBtn, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_iknowBtn, this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }


    private onTap_iknowBtn():void{
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        this.onTouchTap();
    }

    private onTap_closeBtn():void{
        PanelCtrl.instance.btnDelay(this.closeBtn);
        this.onTouchTap();
    }


    private onTap_shareBtn():void{
        PanelCtrl.instance.btnDelay(this.shareBtn);
        
        const startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        const exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        if(window['isdebug'])
        {
            NetManager.ins.getInformation((success,result) => {
                if(success && result.data)
                {
                    let sessionSettings = result.data.sessionSettings.split(',');
                    let endTimeDay = result.data.sessionEndTime.split('-');
                    let date = new Date(endTimeDay[0],endTimeDay[1],endTimeDay[2]).getTime();
                    let endTime  =  date + sessionSettings[sessionSettings.length - 1]*3600000 + result.data.sessionDuration;
                    if(result.data.timestamp < endTime)
                    {
                        NetManager.ins.addTimeShare((success,result) => {
                            if(success && result)
                            {
                         
                                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2});
                            }
                            else
                            {
                                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
                            }
                        });
                    }
                } 
            })
            return ;
        }
        
        if(window['inApp'])
        {
            PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL); 
        }
        else
        {
            PanelCtrl.instance.show(ModuleTypes.TIME_TIPS_PANEL); 
        }
    }
    private onLoad():void{
        if(this.mData){
            switch(this.mData.type){
                case 1:
                    this.unshare.visible = false;
                    this.share.visible = true;
                    const startDpmOut2 = Buried.connectDpm(110, 7, 1); // 点击埋点   
                    const startDcmOut2 = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    const exposure2 = Buried.createExposure(startDpmOut2, startDcmOut2);
            
                    NetManager.ins.showLog(exposure2);
                    break;
                case 2:
                    this.unshare.visible = true;
                    this.share.visible = false;
                break;
            }
        }
    }
    onTouchTap():any{
        super.onTouchTap();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}