
import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import SvgaCtrl from "../ctrls/svgaCtrl";
import { NetNameNew } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { GTime } from '../../libs/tc/util/GTime';
import { TimeFormat } from '../../libs/tc/enum/TimeFormat';
import { LotteryType } from '../../libs/tw/enum/LotteryType';
import { MyHeartItem } from "../components/MyHeartItem";
import { BubbleItem } from "../components/BubbleItem";


export default class FriendKitchenScene extends Scene {

    public backBtn:eui.Button;
    public studyBtn:eui.Button;
 
    public startSceneBg:eui.Image;
    public startBar:eui.Image;

    public modelGroup:eui.Group;
    public heartGroup:eui.Group;

    //饼干数量
    public biscuitsCount:eui.Label;
    //幸福值
    public happinessLb:eui.Label;
    //幸福值进度条
    public pBar:eui.ProgressBar;

    //状态
    private stateNormalViolet:SVGA.EgretMovieClip;
    private stateNormalGreen:SVGA.EgretMovieClip;
    private stateNormalRed:SVGA.EgretMovieClip;
    private stateDozeGreen:SVGA.EgretMovieClip;
    private stateDozeRed:SVGA.EgretMovieClip;
    private stateDozeViolet:SVGA.EgretMovieClip;
    private stateStudyGreen:SVGA.EgretMovieClip;
    private stateStudyRed:SVGA.EgretMovieClip;
    private stateStudyViolet:SVGA.EgretMovieClip;
    private stateMakeGreen:SVGA.EgretMovieClip;
    private stateMakeRed:SVGA.EgretMovieClip;
    private stateMakeViolet:SVGA.EgretMovieClip;

    private playState:any;
    private mData;
    

    private scene1:egret.Texture;
    private scene2:egret.Texture;

    private timeContinued = 0;
    private intervalID;
     //滤镜
     private colorFlilter;

    public get skinKey() { return 'FriendKitchenScene' }
    public get groupName() { return 'friendkitchen_scene'}

    private curHappinessValue:number = 0;
    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBackBtn,this);
        this.studyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickStudy,this);
    }

    removeEvents() {
        super.removeEvents();
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickBackBtn,this);
        this.studyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickStudy,this);
    }

    start(data?) {
        super.start(data);
        this.mData = data;
        this.percentHeight = 100;
    }

    protected async preLoadRes() {
        this.scene1 =await RES.getResAsync('stratBg1_jpg');
        this.scene2 =await RES.getResAsync('stratBg2_jpg');

        this.stateNormalViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalViolet.svga') as SVGA.EgretMovieClip;
        this.stateNormalGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalGreen.svga') as SVGA.EgretMovieClip;
        this.stateNormalRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateNormalRed.svga') as SVGA.EgretMovieClip;
        this.stateDozeGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeGreen.svga') as SVGA.EgretMovieClip;
        this.stateDozeRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeRed.svga') as SVGA.EgretMovieClip;
        this.stateDozeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateDozeViolet.svga') as SVGA.EgretMovieClip;
        this.stateStudyGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyGreen.svga') as SVGA.EgretMovieClip;
        this.stateStudyRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyRed.svga') as SVGA.EgretMovieClip;
        this.stateStudyViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateStudyViolet.svga') as SVGA.EgretMovieClip;
        this.stateMakeGreen = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeGreen.svga') as SVGA.EgretMovieClip;
        this.stateMakeRed = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeRed.svga') as SVGA.EgretMovieClip;
        this.stateMakeViolet = await SvgaCtrl.instance.getSvga('resource/assets/svga/stateMakeViolet.svga') as SVGA.EgretMovieClip;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
      
    }
    private onLoad(): void {
        var colorMatrix = [
            0.3,0.6,0,0,0,
            0.3,0.6,0,0,0,
            0.3,0.6,0,0,0,
            0,0,0,1,0
        ];
        this.colorFlilter = new egret.ColorMatrixFilter(colorMatrix);
        this.initData();
    }
    private initData(){
        if(this.mData && this.mData.userId)
        {
            NetManager.ins.getFriendDetail((success,result) => {
                if(!result)
                {
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
                if(!success)
                {
                    if(!result.code){
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                        return;
                    }else if(result.code == '100001'){
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                        return;
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                        return;
                    }
                }
                this.initUI();
            },this.mData.userId)
        }
        else
        {
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试'});
            this.playSVGA(this.stateNormalViolet);
        }      
    }
    private initUI():void{
        let suitId = DataManager.ins.getData('getFriendDetail').data.suitId;
        let sceneId = DataManager.ins.getData('getFriendDetail').data.sceneId;
        this.initPlayState(suitId?suitId:'suit_1');
    

        this.playSVGA(this.playState.normal);
         this.setSceneBg(sceneId?sceneId:'scene_1');
        //饼干数
        this.biscuitsCount.text = DataManager.ins.getData('getFriendDetail').data.cookies + '块';
        let happinessValue = DataManager.ins.getData('getFriendDetail').data.happinessValue;
        this.curHappinessValue = happinessValue;
        this.setHappinessValue(happinessValue);
        if(!DataManager.ins.getData('getFriendDetail').data.canReceive)
        {
            this.studyBtn.filters = [this.colorFlilter];
        }
    }
    private setSceneBg(sceneID){
        if(sceneID == 'scene_1')
        {
            this.startSceneBg.texture = this.scene1;
        }
        if(sceneID == 'scene_2')
        {
            this.startSceneBg.texture = this.scene2;
        }
        
    }
    //设置 模型 svga 播放状态
    private initPlayState(suitID){
        switch(suitID)
        {
            case 'suit_1':
                this.playState = {'normal':this.stateNormalViolet,
                                  'doze':this.stateDozeViolet,
                                  'study':this.stateStudyViolet,
                                  'make':this.stateMakeViolet}
                break;
            case 'suit_2':
                this.playState = {'normal':this.stateNormalGreen,
                                    'doze':this.stateDozeGreen,
                                    'study':this.stateStudyGreen,
                                    'make':this.stateMakeGreen}
                break;
            case 'suit_3':
                this.playState = {'normal':this.stateNormalRed,
                                    'doze':this.stateDozeRed,
                                    'study':this.stateStudyRed,
                                    'make':this.stateMakeRed}
                break;
        }
        
    }
    private playSVGA(action:SVGA.EgretMovieClip,callback?: Function){
        this['modelGroup'].removeChildren();
        this['modelGroup'].addChild(action);
        if(callback)
        {
            action.startAniRange(1,action.totalFrames,1,callback.bind(this));
        }
        else
        {
            action.play();
        }
    }
    //设置 幸福值
    private setHappinessValue(happinessValue){
        let value = 0;
        if(happinessValue < 100){
            value = happinessValue;
        }else{
            value = happinessValue % 100;
        }
        this.happinessLb.text = value + '';
        this.pBar.value = value;
    }
   
    private addHappiness(vaule:number,callback?: Function){
        let initVaule = 0;
        egret.Tween.get(this.happinessLb, {loop:true}).wait(vaule/1000).call(() => {
            initVaule ++;
            let curValue = (this.curHappinessValue % 100) + initVaule;
            this.happinessLb.text = curValue + '';
            
            if(initVaule >= vaule){
                callback();
                egret.Tween.removeTweens(this.happinessLb); 
            }
        });
    }
    private moveHerat(){
        if(this.timeContinued >= 800)
        {
            clearInterval(this.intervalID);
            return;
        }
        this.timeContinued += 200;
        let dItem = new MyHeartItem();
        this.heartGroup.addChild(dItem);
        dItem.x = 0;
        dItem.y = 0;
    }
    //点击返回按钮
    private onClickBackBtn(){
        SceneCtrl.instance.change(ModuleTypes.START_SCENE,{data:true});
    }
    private onClickStudy(){
        NetManager.ins.getHelpReceive((success,result) => {
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else if(result.code == '603001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'不是好友关系'});
                    return;
                }else if(result.code == '603002'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'还不能学厨艺哦，稍后再来吧！'});
                    return;
                }else if(result.code == '603003'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'已帮好友收取过'});
                    return;
                }else if(result.code == '603004'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'今日收取已达上限'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }

            this.collectHappiness();
        },this.mData.userId)
    }
   private collectHappiness(){
        this.intervalID = setInterval(function(){this.moveHerat()}.bind(this),200);
        this.playSVGA(this.playState.study)
        this.addHappiness(10,function(){
            let collectSetInterval = setInterval(function(){
                clearInterval(collectSetInterval);
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'收取成功，幸福值+10'});
                this.initData();
                //this.setHappinessValue(this.curHappinessValue + 10);
                //this.playSVGA(this.playState.make,()=>{this.playSVGA(this.playState.normal); this.initData();})
            }.bind(this),1600);
        }.bind(this));
   }
}
