
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleType } from '../../libs/tc/enum/ModuleType';
import { ModuleTypes } from '../types/sceneTypes';
import { FriendItem } from "../components/FriendItem";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import SceneCtrl from "../ctrls/sceneCtrl";
export default class FriendKitchenPanel extends Panel {

    public closeBtn:eui.Button;
    public friendListGroup:eui.Group;
    public friendNoGroup:eui.Group;
    public friendDataGroup:eui.Group;
    private friendNoCloseBtn:eui.Button;

    public friendBg:eui.Image;
    private bgtexture:egret.Texture;

    public friendGroupBg:eui.Image;
    private bgtexture1:egret.Texture;

    public get skinKey() { return 'FriendKitchenPanel' }
    public get groupName() { return 'friendkitchen_panel' }

    constructor(data: any) {
        super(data);
    }

    protected async preLoadRes() {
        this.bgtexture = await RES.getResAsync('friendKitchenBg_jpg');
        this.bgtexture1 = await RES.getResAsync('msgBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.friendBg.texture = this.bgtexture;
        this.friendGroupBg.texture = this.bgtexture1;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.friendNoCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeFriendNoBtn, this);
        
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.friendNoCloseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeFriendNoBtn, this);
    }

    private onLoad():void{
        this.friendListGroup.visible = false;
        this.friendNoGroup.visible = false;
        this.initUI();
    }

    private initUI(){
        NetManager.ins.getFriendList((success,result)=>{
            if(!result)
            {
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                this.hidePanel();
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            if(result && result.data.length > 0)
            {
                this.friendListGroup.visible = true;
                this.friendNoGroup.visible = false;
                this.initFriendData(result);
            }
            if(result && result.data.length <= 0)
            {
                this.friendListGroup.visible = false;
                this.friendNoGroup.visible = true;
            }
        })
    }
    private initFriendData(result){
        for(let i=0; i<result.data.length; i++)
        {
            let data = result.data[i];
            let dItem = new FriendItem(data,i,this.onClickBack.bind(this));
            this.friendDataGroup.addChild(dItem);
            dItem.x = 1;
            dItem.y = i * (105 + 10);
        }
    }
    private onClickBack(friendId){
        console.log('好友ID-',friendId);
        SceneCtrl.instance.change(ModuleTypes.FRIEDN_KITCHEN_SCENE,{userId:friendId});
        this.hidePanel();
    }
    private onTap_closeBtn(){
        this.hidePanel();
    }
    private onTap_closeFriendNoBtn(){
        this.friendNoGroup.visible = false;
        this.hidePanel();
    }
}