import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleType } from '../../libs/tc/enum/ModuleType';
import { ModuleTypes } from '../types/sceneTypes';
import { ExchangeItem } from "../components/ExchangeItem";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { GetBuriedData } from "../GetBuriedData";

export default class ExchangePanel extends Panel {

    public closeBtn:eui.Button;
    public itemGroup:eui.Group;
    public changeGroup:eui.Group;
    public prizeGroup:eui.Group;

    public giftIcon:eui.Image;
    public changeCloseBtn:eui.Button;
    public changeTitile:eui.Label;
    public changeGetBtn:eui.Button;

    private giftID:string = '';
    public get skinKey() { return 'ExchangePanel' }
    public get groupName() { return 'change_panel' }

    private sceneIcon:egret.Texture;
    private suitIcon2:egret.Texture;
    private suitIcon3:egret.Texture;

    public bg:eui.Image;
    public changeGroupBg:eui.Image;
    private bgtexture1:egret.Texture;
    private bgtexture2:egret.Texture;
    constructor(data: any) {
        super(data);
    }
    protected async preLoadRes() {
        this.sceneIcon = await RES.getResAsync('scene2_png');
        this.suitIcon2 = await RES.getResAsync('suit2_png');
        this.suitIcon3 = await RES.getResAsync('suit3_png');

        this.bgtexture1 = await RES.getResAsync('changeBg_jpg');
        this.bgtexture2 = await RES.getResAsync('changeSureBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        //this.pMask.visible = false;
        this.bg.texture = this.bgtexture1;
        this.changeGroupBg.texture = this.bgtexture2;

        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.changeCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_changeCloseBtn, this);
        this.changeGetBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_changeGetBtn, this);
        
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.changeCloseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_changeCloseBtn, this);
        this.changeGetBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_changeGetBtn, this);
    }

    private onLoad():void{
        this.changeGroup.visible = false;
        NetManager.ins.getGiftList((success,result) => {
            if(!result)
            {
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                this.hidePanel();
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            this.getPrizeDetail(result);
        })
    }
    private getPrizeDetail(result){
        let prizeID:string = '';
        for(let i=0; i < result.data.length; i++)
        {
            let data = result.data[i];
            prizeID += data.giftId + ',';
        }
        prizeID = prizeID.substring(0,prizeID.length-1);
        this.handleTaskData(prizeID);
    }
    private handleTaskData(prizeID){
        NetManager.ins.getPrizeDetail((success,result) => {
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            
            this.initGiftData();
        },prizeID)

    }
    private initGiftData(){
        NetManager.ins.showLog(GetBuriedData(4));
        NetManager.ins.showLog(GetBuriedData(5));
        NetManager.ins.showLog(GetBuriedData(6));
        NetManager.ins.showLog(GetBuriedData(7));
        NetManager.ins.showLog(GetBuriedData(8));
        NetManager.ins.showLog(GetBuriedData(9));
        NetManager.ins.showLog(GetBuriedData(10));
        NetManager.ins.showLog(GetBuriedData(11));

        let giftData = DataManager.ins.getData('getGiftList').data;
        let curCookies = DataManager.ins.getData('getIndex').data.cookies;
        console.log('giftData',giftData);
        for(let i=0; i<giftData.length; i++)
        {
            let data = giftData[i];
            let name = '';
            let icon = '';
            let iconTexture;

            if(data.giftId == "scene_2"){
                name = '场景2';
                iconTexture = this.sceneIcon;
            }else if(data.giftId == "suit_2"){
                name = '小熊套装2';
                iconTexture = this.suitIcon2;
            }else if(data.giftId == "suit_3")
            {
                name = '小熊套装3';
                iconTexture = this.suitIcon3;
            }else{
                let itemData = this.getPrizeDetailData(data.giftId);
                name = itemData.name;
                icon = itemData.icon;
            }
            let dItem = new ExchangeItem(data.giftId,data.needCookies,data.status,name,icon,curCookies,iconTexture,this.onClickBack.bind(this));
            this.itemGroup.addChild(dItem);
            dItem.x = 1;
            dItem.y = i * (155 + 5);

        }
    }
    private getPrizeDetailData(prizeID){
        let giftItemData = DataManager.ins.getData('getPrizeDetail').data;
        for(let i=0; i<giftItemData.length; i++)
        {
            let itemData = giftItemData[i];
            if(itemData.id == prizeID)
            {
                return itemData;
            }
        }
        return null;

    }
    private onClickBack(giftID:string,iconUrl:string,cookies:number){
        let curCookies = DataManager.ins.getData('getIndex').data.cookies;
        if(curCookies < cookies)
        {
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'饼干不足，先去制作饼干吧'});
            GDispatcher.dispatchEvent('guideTask');
            this.hidePanel();
            return;
        }
        this.changeGroup.visible = true;
        this.changeTitile.text = '确认消耗'+ cookies +'块饼干兑换？';
   
        if(giftID == "scene_2"){
            this.giftIcon.texture = this.sceneIcon;
        }else if(giftID == "suit_2"){
            this.giftIcon.texture = this.suitIcon2;
        }else if(giftID == "suit_3")
        {
            this.giftIcon.texture = this.suitIcon3;
        }else{
            this.giftIcon.source = iconUrl;
        }
    
        this.giftID = giftID;
    }



    private onTap_closeBtn(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        GDispatcher.dispatchEvent('guideTask');
        this.hidePanel();
        
    }
    private onTap_changeCloseBtn(){
        this.changeGroup.visible = false;
    }
    private onTap_changeGetBtn(){
        NetManager.ins.getExChangeGift((success,result)=>{
            if(!result)
            {
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                this.hidePanel();
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'兑换成功'});
            this.changeGroup.visible = false;
            this.onLoad();
            this.setBuried(this.giftID);
            this.giftID = '';
            GDispatcher.dispatchEvent('guideTask');
            GDispatcher.dispatchEvent('Exchange_InitDa');
            this.hidePanel();
        },this.giftID)
    }
    private setBuried(giftID){
        switch (giftID) {
            case 'suit_2':
                NetManager.ins.clickLog(GetBuriedData(4));
                break;
            case 'suit_3':
                NetManager.ins.clickLog(GetBuriedData(5));
                break;
            case 'scene_2':
                NetManager.ins.clickLog(GetBuriedData(6));
                break;
            case 'sss_1':
                NetManager.ins.clickLog(GetBuriedData(7));
                break;
            case 'sss_2':
                NetManager.ins.clickLog(GetBuriedData(8));
                break;
            case 'sss_3':
                NetManager.ins.clickLog(GetBuriedData(9));
                break;  
            case 'sss_4':
                NetManager.ins.clickLog(GetBuriedData(10));
                break;    
            case 'sss_5':
                NetManager.ins.clickLog(GetBuriedData(11));
                break;         
            default:
                break;
        }
       

    }
}