import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleType } from '../../libs/tc/enum/ModuleType';
import { ModuleTypes } from '../types/sceneTypes';
import { TaskItemComponent } from "../components/TaskItemComponent";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';


export default class DressPanel extends Panel {
    public closeBtn:eui.Button;
    public sceneUpBtn1:eui.Button;
    public sceneUpBtn2:eui.Button;
    public suitUpBtn1:eui.Button;
    public suitUpBtn2:eui.Button;
    public suitUpBtn3:eui.Button;

    public scene1:eui.Group;
    public scene2:eui.Group;

    public suit1:eui.Group;
    public suit2:eui.Group;
    public suit3:eui.Group;
    //套装id
    private suitId:number;
    //场景id
    private sceneId:number;

    private sceneIcon1:egret.Texture;
    private sceneIcon2:egret.Texture;

    private suitIcon1:egret.Texture;
    private suitIcon2:egret.Texture;
    private suitIcon3:egret.Texture;

    public bg:eui.Image;
    private bgtexture:egret.Texture;
    public get skinKey() { return 'DressPanel' }
    public get groupName() { return 'dress_panel' }

    constructor(data: any) {
        super(data);
    }

    protected async preLoadRes() {

        this.sceneIcon1 =await RES.getResAsync('scene1_png');
        this.sceneIcon2 =await RES.getResAsync('scene2_png');

        this.suitIcon1 =await RES.getResAsync('suit1_png');
        this.suitIcon2 =await RES.getResAsync('suit2_png');
        this.suitIcon3 =await RES.getResAsync('suit3_png');

        this.bgtexture = await RES.getResAsync('dressPanelBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.bg.texture = this.bgtexture;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);

        for(let i = 0; i < 2; i++)
        {
            this['scene' + (i+1)].getChildByName('sceneUpBtn'+(i+1)).addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        }
        for(let i = 0; i < 3; i++)
        {
            this['suit' + (i+1)].getChildByName('suitUpBtn'+(i+1)).addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        }
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);

        for(let i = 0; i < 2; i++)
        {
            this['scene' + (i+1)].getChildByName('sceneUpBtn'+(i+1)).removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        }
        for(let i = 0; i < 3; i++)
        {
            this['suit' + (i+1)].getChildByName('suitUpBtn'+(i+1)).removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        }
    }

    private onLoad():void{

        this.initUI();
    }
    private initUI(){
        for(let i = 0; i < 2; i++)
        {
            this['scene' + (i+1)].getChildByName('sceneUpBtn'+(i+1)).enabled = false;
        }
        for(let i = 0; i < 3; i++)
        {
            this['suit' + (i+1)].getChildByName('suitUpBtn'+(i+1)).enabled = false;
        }

        NetManager.ins.getDressList((success,result) => {
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }
            }else{
                this.initScene(result.data.sceneList);
                this.initSuit(result.data.suitList);
            }
 
        })
    }
    private initScene(sceneList){
        for(let i=0; i < sceneList.length; i++)
        {
            let sceneData = sceneList[i];
            let item = null;
            let itemButton = null;
            if(!this['scene1'].visible)
            {
                item =  this['scene1'];
                itemButton = item.getChildByName('sceneUpBtn1');
            }else if(!this['scene2'].visible)
            {
                item =  this['scene2'];
                itemButton = item.getChildByName('sceneUpBtn2');
            }
            if(sceneData.status == 0)
            {
                console.log('按钮',itemButton.name,sceneData.status);
                itemButton.enabled = true;
            }else if(sceneData.status == 1){
                console.log('按钮1',itemButton.name,sceneData.status);
                itemButton.enabled = false;
            }
            if(sceneData.sceneId == 'scene_1')
            {
                item.getChildByName('icon').texture = this.sceneIcon1;
                item.getChildByName('iconName').text = '烘培坊场景';
                item.visible = true;
            }else if(sceneData.sceneId == 'scene_2')
            {
                item.getChildByName('icon').texture = this.sceneIcon2;
                item.getChildByName('iconName').text = '厨房场景';
                item.visible = true; 
            }
        }
    }
    private initSuit(suitList){
        for(let i=0; i < suitList.length; i++)
        {
            let suitData = suitList[i];
            let item = null;
            let itemButton = null;
            if(!this['suit1'].visible)
            {
                item =  this['suit1'];
                itemButton = item.getChildByName('suitUpBtn1');
            }else if(!this['suit2'].visible)
            {
                item =  this['suit2'];
                itemButton = item.getChildByName('suitUpBtn2');
            }else if(!this['suit3'].visible){
                item =  this['suit3'];
                itemButton = item.getChildByName('suitUpBtn3');
            }

            if(suitData.status == 0)
            {
                itemButton.enabled = true;
            }else if(suitData.status == 1){
                itemButton.enabled = false;
            }
            if(suitData.suitId == 'suit_1' )
            {
                item.getChildByName('icon').texture = this.suitIcon1;
                item.getChildByName('iconName').text = '小熊套装1';
                item.visible = true;
            }else if(suitData.suitId == 'suit_2' ){
                item.getChildByName('icon').texture = this.suitIcon2;
                item.getChildByName('iconName').text = '小熊套装2'; 
                item.visible = true;
            }else if(suitData.suitId == 'suit_3'){
                item.getChildByName('icon').texture = this.suitIcon3;
                item.getChildByName('iconName').text = '小熊套装3'; 
                item.visible = true;
            }
        }
    }
    private getSceneNode(){
        for (let index = 1; index < 3; index++) {
            const element = this['scene' + index];
            if(element && !element.isvisible)
            {
                return index;
            }
        }
    }
    private getSuitNode(){
        let nodeData = {'itemNode':null,'itemBtn':null};
        for (let index = 1; index < 4; index++) {
            const element = this['suit' + index];
            if(element && !element.visible)
            {
                nodeData.itemNode = element;
                nodeData.itemBtn = element.getChildByName('suitUpBtn'+index);
                
                return element;
            }
        }
    }
    private onClickBtn(e:egret.TouchEvent){
        let nameBtn = e.target.name;
        switch(nameBtn)
        {
            case 'sceneUpBtn1':
                this.dressChange(1,'scene_1');
                break;
            case 'sceneUpBtn2':
                this.dressChange(1,'scene_2');
                break;
            case 'suitUpBtn1':
                this.dressChange(2,'suit_1');
                break;
            case 'suitUpBtn2':
                this.dressChange(2,'suit_2');
                break;
            case 'suitUpBtn3':
                this.dressChange(2,'suit_3');
                break;     
        }
    }
    private dressChange(dressType,dressId){
        NetManager.ins.getDressUp((success,result) => {
            if(!result)
            {
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                this.hidePanel();
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                    return;
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                    return;
                }
            }
            if(success)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'装扮成功'});
                this.hidePanel();
                
                if(dressType == 1)
                {
                    this.setSceneButtonState(dressId);
                }
                if(dressType == 2)
                {
                    this.setSuiButtonState(dressId);
                } 
                
                GDispatcher.dispatchEvent('changeSuit');
            }
        },dressType,dressId)
    }

    private onChange(){

    }
    private onTap_closeBtn(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        this.hidePanel();
    }

    private setSceneButtonState(buttonType){
        this.sceneUpBtn1.enabled = true;
        this.sceneUpBtn2.enabled = true;
        switch(buttonType)
        {
            case 1:
                this.sceneUpBtn1.enabled = false;
                break;
            case 2:
                this.sceneUpBtn2.enabled = false;
                break;
        }
    }
    private setSuiButtonState(buttonType){
        this.suitUpBtn1.enabled = true;
        this.suitUpBtn2.enabled = true;
        this.suitUpBtn3.enabled = true;
        switch(buttonType)
        {
            case 1:
                this.suitUpBtn1.enabled = false;
                break;
            case 2:
                this.suitUpBtn2.enabled = false;
                break;
            case 3:
                this.suitUpBtn3.enabled = false;
                break;
        }
    }

}