import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Loading from "../loading/Loading";
import { VideoEntity } from "../../libs/SVGA";
export default class SvgaCtrl {
    private _parser:SVGA.Parser;
 

    static _instance: SvgaCtrl;
    static get instance() {
        return SvgaCtrl._instance || (SvgaCtrl._instance = new SvgaCtrl())
    }

    //异步加载svg
    public async getSvga(url:string){
        url = window['resPath'] + url;
        console.log('rul:', url)
        return new Promise((resolve) => {
            if(!this._parser){
                this._parser = new SVGA.Parser();
            }
            this._parser.load(url, (video:VideoEntity)=>{
                let result = new SVGA.EgretMovieClip(video);
                resolve(result);
            });
        });
    }

    //异步加载音效
    public async getSound(url:string, thisobject:any){
        return new Promise((resolve) => {
            RES.getResByUrl(url, (data,url)=>{
                console.log('urlsound', url);
                resolve(url);
            }, thisobject, RES.ResourceItem.TYPE_SOUND);
        });
    }
}