
import PanelCtrl from "../ctrls/panelCtrl";

export class TaskItemComponent extends eui.Component{

    public prizeItemGroup:eui.Group;
    //点击收取回调
    private clickCallBack:Function;

    public onlyName:eui.Label;
    public countLb:eui.Label;

    public prizeTime:eui.Label;
    public unCompleteBtn:eui.Button;
    public completeBtn:eui.Button;
    public goGiveBtn:eui.Button;
    public receivedBtn:eui.Button;
    public taskShareBtn:eui.Button;
    public pBar:eui.ProgressBar;
    public nameLb:eui.Label;
    public barCount:eui.Label;
    public onlyNameGroup:eui.Group;
    public nameGroup:eui.Group;

    //点击的 按钮 类型
    private  taskType:number;
    /**
     * @param callBack 回调函数
     */
    constructor(taskData, callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/ui/TaskItemSkin.exml';
    
        if(taskData.taskType == 2 || taskData.taskType == 3 || taskData.taskType == 4)
        {
            this.onlyNameGroup.visible = false;
            this.nameGroup.visible = true;
            console.log('任务',taskData);
            if(taskData.completeCount > taskData.totalCount)
            {
                this.pBar.value = 100;
            }
            else
            {
                this.pBar.value = (taskData.completeCount / taskData.totalCount)*100;
            }
            this.nameLb.text = taskData.taskName;
            this.barCount.text = '('+taskData.completeCount+'/'+taskData.totalCount+')';
        }
        else
        {
            this.onlyNameGroup.visible = true;
            this.nameGroup.visible = false;
            this.onlyName.text = taskData.taskName;
        }
        this.taskType = taskData.taskType;
        this.countLb.text = taskData.happinessValue;
        this.setButtonState(taskData.taskStatus);
        this.clickCallBack  = callBack;
        
        this.taskShareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.completeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private setButtonState(buttonType){
        this.unCompleteBtn.visible = false;
        this.completeBtn.visible = false;
        this.goGiveBtn.visible = false;
        this.receivedBtn.visible = false;
        this.taskShareBtn.visible = false;

        switch(buttonType)
        {
            case 1:
                this.unCompleteBtn.visible = true;
                break;
            case 2:
                this.completeBtn.visible = true;
                break;
            case 3:
                this.taskShareBtn.visible = true;
                break;
            case 4:
                this.unCompleteBtn.visible = true;
                break;
            case 5:
                this.receivedBtn.visible = true;
                break;
        }
    }
    private onSkinComplete():void{
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent():void{
        this.taskShareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.completeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
    }

    private onTap_buyBtn():void{

        if(this.clickCallBack){
            if(!window['newUserGuide'])
            {
                this.clickCallBack(this.taskType);
            }
        }
    }
}