
import PanelCtrl from "../ctrls/panelCtrl";

export class FriendItem extends eui.Component{

    public nameLb:eui.Label;
    public getBtn:eui.Button;
    public getedBtn:eui.Button;
    public userId:string;

    //点击收取回调
    private clickCallBack:Function;
    /**
     * @param callBack 回调函数
     */
    constructor(friendData,index, callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/ui/FriendItem.exml';
    
        this.setButtonState(friendData.status);
        this.clickCallBack  = callBack;
        let nickname = '';
        if(friendData.nickname)
        {
            // if(friendData.nickname.length > 6)
            // {
            //     nickname = friendData.nickname.substr(0,6) + "...";
            // }else{
            //     nickname = friendData.nickname;
            // }
            nickname = friendData.nickname;
        }else{
            nickname = '小熊厨房好友' + (index+1);
        }
         
        this.nameLb.text = nickname;
        this.userId = friendData.userId;

        this.getBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_clickBtn, this);
        this.getedBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_clickBtn, this);

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private setButtonState(buttonType){
        this.getBtn.visible = false;
        this.getedBtn.visible = false;
        switch(buttonType)
        {
            case 0:
                this.getBtn.visible = true;
                break;
            case 1:
                this.getedBtn.visible = true;
                break;
        }
    }
    private onSkinComplete():void{
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent():void{
        this.getBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_clickBtn, this);
        this.getedBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_clickBtn, this);
    }

    private onTap_clickBtn():void{
        if(this.clickCallBack){
            this.clickCallBack(this.userId);
        }
    }
}