
import PanelCtrl from "../ctrls/panelCtrl";

export class ExchangeItem extends eui.Component{

    public changGroup1:eui.Group;
    public changGroup2:eui.Group;
    public unChangeGroup:eui.Group;
    public withoutGroup:eui.Group;
    //点击收取回调
    private clickCallBack:Function;



    public getBtn:eui.Button;
    public noChangeBtn:eui.Button;


    public icon:eui.Image;
    public needCount:eui.Label;
    public prizeName:eui.Label;
    public needBtnLab:eui.Label;
    public needBtnLab2:eui.Label;

    private cookies:number;
    private curCookies:number;
    private giftID:string;
    private iconUrl:string;

    private sceneIcon:egret.Texture;
    private suitIcon2:egret.Texture;
    private suitIcon3:egret.Texture;

    private needCookies:number;

    /**
     * @param callBack 回调函数
     * @param needCookies 兑换需要的饼干数
     * @param status 兑换状态
     * @param name 奖品名字
     * @param icon 奖品图
     * @param giftId 好礼ID
     */
    constructor(giftId:string,needCookies:number,status:number,name:string,icon:string,curCookies:number,iconTexture?, callBack:Function = null){
        super();

        this.skinName       = 'resource/skins/ui/ExchangeItem.exml';

        if(icon == '')
        {
            this.icon.texture = iconTexture;
            this.icon.width = iconTexture.width;
            this.icon.height = iconTexture.height;
        }
        else
        {
            this.icon.source = icon;
            this.iconUrl = icon;
        }
        this.prizeName.text = name;
        this.giftID = giftId;
        this.cookies = needCookies;
        this.curCookies = curCookies;
        this.needCount.text = 'x' + needCookies + '';

        this.setButtonState(status);
        this.clickCallBack  = callBack;

        this.getBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.noChangeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
      


        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private setButtonState(buttonType){
        this.changGroup1.visible = false;
        this.changGroup2.visible = false;
        this.unChangeGroup.visible = false;
        this .withoutGroup.visible = false;
        switch(buttonType)
        {
            case 1:
                this.changGroup2.visible = true;
                this.needBtnLab2.text = this.curCookies + '/' + this.cookies;
                break;
            case 2:
                this.withoutGroup.visible = true;
                break;
            case 3:
                this.changGroup1.visible = true;
                this.needBtnLab.text = this.curCookies + '/' + this.cookies;
                break;
            case 4:
                this.unChangeGroup.visible = true;
                break;
        }
    }
    protected async preLoadRes() {
        this.sceneIcon = await RES.getResAsync('scene2_png');
        this.suitIcon2 = await RES.getResAsync('suit2_png');
        this.suitIcon3 = await RES.getResAsync('suit3_png');
    
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    private onSkinComplete():void{
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        
    }

    public removeEvent():void{
        this.getBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.noChangeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
    }

    private onTap_buyBtn():void{
        if(this.clickCallBack){
            if(!window['newUserGuide'])
            {
                this.clickCallBack(this.giftID,this.iconUrl,this.cookies);
            }
            
            //PanelCtrl.instance.btnDelay(this.prizeItemGroup);
        }
    }
}