

export class BubbleItem extends eui.Component{
   private clickCallBack;
   private needMoveX:number = 0;
   private needMoveY:number = 0;
    constructor(moveX,moveY,callBack:Function){
        super();
        this.skinName       = 'resource/skins/ui/BubbleItem.exml';
        this.clickCallBack = callBack;
        this.needMoveX = moveX;
        this.needMoveY = moveY;
        let time = Math.floor(Math.random()*2000);  
        let intervalID = setInterval(function(){
            clearInterval(intervalID);
            egret.Tween.get(this,{loop:true})
            .to({y:-10}, 500)
            .to({y:0}, 500)
            .to({y:10},500)
            .to({y:0},500)
        }.bind(this),time);

        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_collect, this);
        //this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
       
    }

    public removeEvent():void{
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_collect, this);
    }
    private onTap_collect(){
        egret.Tween.removeTweens(this);
        var targetPoint: egret.Point = this.globalToLocal(this.needMoveX, this.needMoveY);
        egret.Tween.get(this,{loop:false})
        .to({scaleX:0, scaleY:0}, 800)
    
        egret.Tween.get(this,{loop:false})
        .to({x:targetPoint.x-10, y:targetPoint.y+80}, 600).call(() => {
            this.parent.removeChild(this);
            this.clickCallBack()
        });
    }
}