
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { AssistanceItem } from "../components/AssistanceItem";
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import SceneCtrl from "../ctrls/sceneCtrl";
import { buttonTypes } from './../types/buttonTypes';
import { GetBuriedData } from "../GetBuriedData";

export default class AssistancePanel extends Panel {


    public friendListGroup:eui.Group;
    public friendList:eui.Scroller;
    public friendHint:eui.Label;
    public invitationBtn:eui.Button;

    private inviteCode:string = '';
    public friendListBg:eui.Image;
    private friendListTexture:egret.Texture;

    public bg:eui.Image;
    private bgtexture:egret.Texture;
    public get skinKey() { return 'AssistancePanel' }
    public get groupName() { return 'invitation_panel' }

    constructor(data: any) {
        super(data);
    }

    protected async preLoadRes() {
        this.bgtexture = await RES.getResAsync('invitationBg_jpg');
        this.friendListTexture = await RES.getResAsync('friendListBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.bg.texture = this.bgtexture;
        this.friendListBg.texture = this.friendListTexture;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.invitationBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickInvitationBtn,this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.invitationBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickInvitationBtn,this);
    }

    private onLoad():void{
        this.inviteCode = this.getQueryString('shareCode');
        this.initUI();
    }

    private initUI(){
        
        NetManager.ins.getHelpList((success,result)=>{
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络出错，请稍后重试'});
                return;
            }
            if(result && result.data.length > 0)
            {
                this.initFriendData(result);
            }
        },this.inviteCode)
    }
    private initFriendData(result){
        if(result.data.length <= 0)
        {
            this.friendList.visible = false;
            this.friendHint.visible = true;
        }
        for(let i=0; i<result.data.length; i++)
        {
            let data = result.data[i];
        
            let dItem = new AssistanceItem(data,i);
            this.friendListGroup.addChild(dItem);
            dItem.x = 28;
            dItem.y = i * (100 + 10);
        }
    }
    private onTap_closeBtn(){
        
    }
    private onClickInvitationBtn(){
        console.log('助力码',this.inviteCode);
        NetManager.ins.helpAccept((success,result)=>{
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                return;
            }
            if(!success)
            {
                if(!result.code){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }else if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'请先登录'});
                }else if(result.code == '205001'){
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.JOININ_BTN,
                                            data:['助力失败','只有新用户才能助力哦'],
                                            callBack:function(){console.log("点击返回1")}});
                }else if(result.code == '205002'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'用户不能为自己助力'});
                }else if(result.code == '100013'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'邀请码异常~'});
                }else if(result.code == '100014'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'不能邀请自己~'});
                }else if(result.code == '100015'){
                    //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'已经接受过邀请~'});
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.JOININ_BTN,
                                            data:['助力失败','只有新用户才能助力哦'],
                                            callBack:function(){console.log("点击返回1")}});
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL,{msg:'网络开小差了，请稍后重试~'});
                }
            }

            if(success && result && result.data.newUser)
            {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.GETPRIZE_BTN,
                    data:['助力成功','您已为好友助力成功','赠送给您一份大礼包和小熊厨房新人奖励'],
                    callBack:function(){NetManager.ins.clickLog(GetBuriedData(13));}});
                NetManager.ins.showLog(GetBuriedData(13));
                this.initUI();
                return;
            }
            if(success && result && !result.data.newUser)
            {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{buttonType:buttonTypes.GETPRIZE_BTN,
                    data:['助力成功','您已为好友助力成功','赠送给您一份小熊厨房新人奖励'],
                    callBack:function(){NetManager.ins.clickLog(GetBuriedData(12));}});
                NetManager.ins.showLog(GetBuriedData(12));
                this.initUI();
                return;
            }
        },this.inviteCode)
    }
    private getQueryString(name) {
        var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return unescape(r[2]);
        }
        return null;
    }
}