
// tslint:disable:only-arrow-functions
// tslint:disable:no-conditional-assignment
// tslint:disable:prefer-const
// tslint:disable:no-var-keyword
// tslint:disable:no-inferrable-types
import { sqrt3, degToRad } from "./Const";
import { RegPolygon } from "./RegPolygon";
import { Vector } from "./Vector";
export class RegTriangle extends RegPolygon {

    //中心点到各点长度
    pointLength;
    //中心点到各边长度
    sideLength;

    constructor(length, view) {
        super(length, view);
        this.type="regTriangle";
        this.pointLength = this.length * sqrt3 / 3;
        this.sideLength = this.length * sqrt3 / 6;
    }

    calculateNormals() {
        if (this._rotation == 0) {
            this.sideNormals[0] = new Vector(1, -sqrt3)
            this.sideNormals[1] = new Vector(1, sqrt3)
            this.sideNormals[2] = new Vector(-1, 0)
            this.pointNormals[0] = new Vector(1, 0)
            this.pointNormals[1] = new Vector(-1, sqrt3)
            this.pointNormals[2] = new Vector(-1, -sqrt3)
        } else {
            var rad = this._rotation * degToRad;
            this.sideNormals[0] = new Vector(1, -sqrt3).rotate(rad);
            this.sideNormals[1] = new Vector(1, sqrt3).rotate(rad);
            this.sideNormals[2] = new Vector(-1, 0).rotate(rad);
            this.pointNormals[0] = new Vector(1, 0).rotate(rad);
            this.pointNormals[1] = new Vector(-1, sqrt3).rotate(rad);
            this.pointNormals[2] = new Vector(-1, -sqrt3).rotate(rad);
        }

    }

    calculatePoints() {
        if (this._rotation == 0) {
            this.points[0] = new Vector(0, -this.length * sqrt3 / 3);
            this.points[1] = new Vector(this.length / 2, this.length * sqrt3 / 6);
            this.points[2] = new Vector(-this.length / 2, this.length * sqrt3 / 6);
        } else {
            var rad = this._rotation * degToRad;
            this.points[0] = new Vector(0, -this.length * sqrt3 / 3).rotate(rad);
            this.points[1] = new Vector(this.length / 2, this.length * sqrt3 / 6).rotate(rad);
            this.points[2] = new Vector(-this.length / 2, this.length * sqrt3 / 6).rotate(rad);
        }
    }

    calculateLines() {
        //三边线的方程 左上开始
        this.linesOri = [
            { a: -sqrt3, b: -this.length * sqrt3 / 3 },
            { a: sqrt3, b: -this.length * sqrt3 / 3 },
            { a: 0, b: this.length * sqrt3 / 6 },
        ]
    }


    nearestCollideNormal(returnP) {
        //算出点在三条线的方向 ,在上为true,在下为false
        var zero = this.linesOri[0].a * returnP.x + this.linesOri[0].b - returnP.y > 0;
        var one = this.linesOri[1].a * returnP.x + this.linesOri[1].b - returnP.y > 0;
        var two = this.linesOri[2].a * returnP.x + this.linesOri[2].b - returnP.y > 0;

        // console.log(this.linesOri[0].a * returnP.x + this.linesOri[0].b,returnP.y)
        // console.log(zero,one,two)
        //左上边
        if (zero && !one && two) {
            return this.sideNormals[0];
        }
        //右上边
        else if (!zero && one && two) {
            return this.sideNormals[1];
        }
        //下边
        else if (!zero && !one && !two) {
            return this.sideNormals[2];
        }
        //上点
        else if (zero && one && two) {
            return this.pointNormals[0];
        }
        //右点
        else if (!zero && one && !two) {
            return this.pointNormals[1];
        }
        //左点
        else if (zero && !one && !two) {
            return this.pointNormals[2];
        }
    }
}