import ComponentBase from "./ComponentBase";

export default class Panel extends ComponentBase {
    constructor() {
        super();
    }

    get skinResKey() { return null }

    initEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this) }
        )
    }
    removeEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this) }
        )
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }

    onTouchTap_closeBtn() {
        this.hidePanel();
    }

    hidePanel(rightnow = false) {
        this.destroy();
        const e = new egret.Event('onDestroy');
        e.data = { rightnow: rightnow };
        this.dispatchEvent(e);
    }

}