import ComponentBase from "../libs/new_wx/components/ComponentBase";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import getcredits from "./getcredits";
import { HisDreamType } from "./HisDreamScene";
import join_1_index from "./interfaces/join_1_index";

export default class StarComp extends ComponentBase {
    constructor(txt, id) {
        super();
        this.loadSkin();
        this['txt'].text = txt;
        this.once(egret.TouchEvent.TOUCH_TAP, () => {
            const credits = getcredits();
            NetManager.ins.yyh_join1_dreamDetail(() => {
                const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
                const detail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
                if (new Date().getTime() > join_1_index.data.assistDeadline)
                    SceneCtrl.instance.change('HisDreamScene', HisDreamType.TIMES_OUT);
                else if (detail.assist) { //主力了
                    SceneCtrl.instance.change('HisDreamScene', HisDreamType.HELP_DONE);
                } else {
                    if (join_1_index.data.doAssistCount >= join_1_index.data.doAssistLimit) {//次数限制
                        SceneCtrl.instance.change('HisDreamScene', HisDreamType.TIMES_LIMIT);
                    } else if (credits <= 0) {
                        SceneCtrl.instance.change('HisDreamScene', HisDreamType.MONEY_NOT_ENOUPH);
                    } else {
                        SceneCtrl.instance.change('HisDreamScene', HisDreamType.ENOUPH_TIMES);
                    }
                }
            }, false, id);
        }, this);
    }

    get skinKey(): string { return "Star" }
}