import Scene from "../libs/new_wx/components/Scene";
import { DataManager } from "../libs/tw/manager/DataManager";
import gotoShare from "./gotoShare";
import { getEnergyLimit } from "./datas";
import setBackBtn from "./setBackBtn";
import getDefaultAvatar from "./getDefaultAvatar";
import getDefaultPic from "./getDefaultPic";
export const getProvince = (address:string)=>{
    return address.split(',')[0];
};

export default class MyDreamScene extends Scene {
    async start(data?) {
        super.start();
        this.showlog();
        setBackBtn(this);
        const yyh_join1_dreamDetail = DataManager.ins.getData('yyh_join1_dreamDetail').data;

        this['img'].mask = this['imgMask'];
        this['avatar'].mask = this['avatarMask'];
        // this['avatar'].source =yyh_join1_dreamDetail.avatar|| getDefaultAvatar();

        if (yyh_join1_dreamDetail.avatar == 'null' || !yyh_join1_dreamDetail.avatar) {
            this['avatar'].source = getDefaultAvatar();
        } else
            this['avatar'].source = yyh_join1_dreamDetail.avatar;

        this['from'].text = `来自${getProvince(yyh_join1_dreamDetail.address)}的梦想     编号：${yyh_join1_dreamDetail.id}`;
        this['rank'].text = `能量值：${yyh_join1_dreamDetail.energy}    梦想排名：${yyh_join1_dreamDetail.rank}`;
        this['title'].text =yyh_join1_dreamDetail.dreamTitle;
        this['content'].text =yyh_join1_dreamDetail.dreamContent;

        this['progress'].mask = this['progressmask'];
        if(this.stage.stageHeight < 1252)
            this['scroll'].height = this.stage.stageHeight - this['scroll'].y;
        this.loadImg(yyh_join1_dreamDetail.dreamPic|| getDefaultPic());

        this.setProgress(yyh_join1_dreamDetail);

        this['sharebtn'].addEventListener(egret.TouchEvent.TOUCH_TAP,()=>{
            gotoShare();
        },this);
    }

    private setProgress(yyh_join1_dreamDetail) {
        const nums = yyh_join1_dreamDetail.energy;
        this['progresstxt'].text = `${nums}/${getEnergyLimit()}`;

        this['progressmask'].scaleX = nums/100 > 1 ? 1:nums/100;
    }

    loadImg(url) {
        // const url = 'http://yun.duiba.com.cn/db_games/img1.png';
        // const url = 'http://yun.duiba.com.cn/db_games/img2.jpg';
        RES.getResByUrl(url, (img: egret.Texture) => {
            const oriHeight = this['img'].height;
            const scale = this['imgMask'].width / img.textureWidth;
            this['img'].source = img;
            this['img'].height = img.textureHeight * scale;
            const addHeight = this['img'].height - oriHeight;
            this['imgMask'].height = this['img'].height;
            this['imgbg'].height = this['imgbg'].height + addHeight;
        }, this, RES.ResourceItem.TYPE_IMAGE);
    }

    get resKey() { return 'noname' }
    get skinKey() { return 'MyDream' }

    showlog() { }


}