import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import ListItemRenderer from "./ListItemRenderer";
import { HisDreamType } from "./HisDreamScene";
import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import join_1_index from "./interfaces/join_1_index";
import { getMyInfo } from "./MainScene";
import getcredits from "./getcredits";
import { showToast } from "../libs/new_wx/ctrls/toastCtrl";
import setBackBtn from "./setBackBtn";

export default class ListScene extends Scene {
    list: eui.List;
    list2: eui.List;
    async start(data?) {
        super.start();
        setBackBtn(this);
        this.showlog();

        this['scroll'].height = this.stage.stageHeight - this['scroll'].y - this['group'].y - 10;
        this['scroll2'].height = this.stage.stageHeight - this['scroll2'].y - 10;

        this.list.useVirtualLayout = true;
        this.list.itemRenderer = ListItemRenderer;


        NetManager.ins.yyh_join1_dreamRankList(() => {
            let datalist = DataManager.ins.getData('yyh_join1_dreamRankList').data;
            datalist.forEach(item => {
                item.func = this.onTap_detail;
            });

            const ac = new eui.ArrayCollection(
                datalist
            );
            this.list.dataProvider = ac;
        }, null);

        NetManager.ins.yyh_assist1_myAssistDreamList(() => {
            let datalist2: any = DataManager.ins.getData('yyh_assist1_myAssistDreamList').data;
            datalist2.forEach(item => {
                item.func = this.onTap_detail;
            });
            const ac2 = new eui.ArrayCollection(
                datalist2
            );
            this.list2.dataProvider = ac2;
            this['datalist2']=datalist2;
            // if(this['datalist2'].length <=0 ) {
            //     this['tips'].visible=true;
            // }
        });

        this.list2.useVirtualLayout = true;
        this.list2.itemRenderer = ListItemRenderer;


        this['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btn, this);
        this['btnAll'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btnall, this);
        this['searchbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_searchbtn, this);

        this['group'].visible = true;
        this['scroll2'].visible = false;

    }

    onTap_btn() {
        this['group'].visible = false;
        this['scroll2'].visible = true;
        this['tips'].visible=false;
        egret.Tween.get(this['line']).to({ x: 500 }, 150);
        if(this['datalist2'].length <=0 ) {
            this['tips'].visible=true;
        }
    }

    onTap_btnall() {
        this['group'].visible = true;
        this['scroll2'].visible = false;
        this['tips'].visible=false;
        egret.Tween.get(this['line']).to({ x: 149 }, 150);

    }

    onTap_searchbtn() {
        console.log(this['searchtxt'].text);

        NetManager.ins.yyh_join1_dreamRankList(() => {
            let datalist = DataManager.ins.getData('yyh_join1_dreamRankList').data;
            datalist.forEach(item => {
                item.func = this.onTap_detail;
            });

            if(!datalist || datalist.length==0) {
                showToast('未搜索到结果');
            }
            const ac = new eui.ArrayCollection(
                datalist
            );
            this.list.dataProvider = ac;
        }, this['searchtxt'].text);


    }

    onTap_detail = (id) => {
        // console.log('点击查看详情');
        const credits = getcredits();
        NetManager.ins.yyh_join1_dreamDetail(() => {
            const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
            const detail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
            if (new Date().getTime() > join_1_index.data.assistDeadline)
                SceneCtrl.instance.change('HisDreamScene', HisDreamType.TIMES_OUT);
            else if (detail.assist) { //主力了
                SceneCtrl.instance.change('HisDreamScene', HisDreamType.HELP_DONE);
            } else {
                if (join_1_index.data.doAssistCount >= join_1_index.data.doAssistLimit) {//次数限制
                    SceneCtrl.instance.change('HisDreamScene', HisDreamType.TIMES_LIMIT);
                } else if (credits <= 0) {
                    SceneCtrl.instance.change('HisDreamScene', HisDreamType.MONEY_NOT_ENOUPH);
                } else {
                    SceneCtrl.instance.change('HisDreamScene', HisDreamType.ENOUPH_TIMES);
                }
            }
        }, false, id);
    }

    get skinKey() { return 'List' }

    showlog() { }


}