import Panel from "../../libs/new_wx/components/Panel";
import { HtmlTextParser } from "../../libs/new_wx/HtmlTextParser";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";


export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        super.start();

        NetManager.ins.yyh_queryProjectRule((success)=>{
            let str:string = DataManager.ins.getData('yyh_queryProjectRule').data;
            while(str.indexOf('<p>') != -1) {
                str=str.replace('<p>','');
            }
            while(str.indexOf('</p>') != -1) {
                str=str.replace('</p>','<br>');
            }
            this.addRule('<br>'+str);
        });
    }

    group: eui.Group;
    private addRule(str) {
        const text =str;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }
    protected get closeBtns(): eui.Button[] { return [this['closeBtn'],this['closeBtn1']] }
    
    get skinKey() { return 'Rule' }
}