import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { getMyInfo } from "../MainScene";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import Loading from "../../libs/new_wx/components/Loading";
import getcredits, { updateCredits } from "../getcredits";

const setGray = (d) => {

    //颜色矩阵数组
    var colorMatrix = [
        0.3, 0.6, 0, 0, 0,
        0.3, 0.6, 0, 0, 0,
        0.3, 0.6, 0, 0, 0,
        0, 0, 0, 1, 0
    ];
    var colorFlilter = new egret.ColorMatrixFilter(colorMatrix);
    d.filters = [colorFlilter];
}
export default class CostPanel extends Panel {
    selectOrder;
    start(data) {
        super.start();
        let money = getcredits();

        this['money'].text = `我的能量：${money}`;

        let btns = [1, 2, 3, 4, 5];
        let disables = [];
        if (money >= 5) {
            btns = [1, 2, 3, 4, 5];
            disables = [];
        }
        else if (money == 4) {
            btns = [1, 2, 3, 4];
            disables = [5];
        }
        else if (money == 3) {
            btns = [1, 2, 3];
            disables = [4, 5];
        }
        else if (money == 2) {
            btns = [1, 2];
            disables = [3, 4, 5];
        }
        else if (money == 1) {
            btns = [1];
            disables = [2, 3, 4, 5];
        }

        this.selectOrder = btns[btns.length - 1];
        this[`btn${this.selectOrder}`].enabled = false;
        this['tips'].text = `我将消耗${this.selectOrder}点能量为梦想充能`;

        disables.forEach((i) => {
            this[`btn${i}`].touchEnabled = false;
            setGray(this[`btn${i}`]);
        });
        btns.forEach((i) => {
            (this[`btn${i}`]).addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                for (const btn of btns) {
                    (this[`btn${btn}`]).enabled = true;
                }
                this[`btn${i}`].enabled = false;
                this.selectOrder = i;
                this['tips'].text = `我将消耗${this.selectOrder}点能量为梦想充能`;
            }, this);
        });
        this['okbtn'].once(egret.TouchEvent.TOUCH_TAP, this.ontap_okbtn, this);
    }

    ontap_okbtn() {
        Loading.instace.show();
        console.log(this.selectOrder);
        const detail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
        //助力成功之后重新拿一下数据
        let key = `doAssist`;
        if (this.selectOrder > 1)
            key += `${this.selectOrder}`;
        NetManager.ins.yyh_creditsCost((success) => {
            if (success) {
                const ticketNum = DataManager.ins.getData('yyh_creditsCost').data;
                NetManager.ins.yyh_queryStatus((s) => {
                    if (s && DataManager.ins.getData('yyh_queryStatus').data == 1) {
                        NetManager.ins.yyh_assist1_doAssist(async (success) => {
                            Loading.instace.hide();
                            updateCredits();
                            if (success) {
                                this.hidePanel(false, 1);
                            } else {
                                this.hidePanel(false);
                            }
                        }, detail.assistItemId, detail.id, this.selectOrder, ticketNum);
                    } else {
                        this.hidePanel(false);
                        updateCredits();
                        Loading.instace.hide();
                    }
                }, ticketNum, () => {
                    return DataManager.ins.getData('yyh_queryStatus').data == 0
                });
            } else {
                this.hidePanel(false);
                updateCredits();
                Loading.instace.hide();
            }
        }, 'assist_1', key);
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }
    get skinKey() { return 'Cost' }
}