import Scene from "../libs/new_wx/components/Scene";
import getRequest from "./getRequest";
import { getProvince } from "./MyDreamScene";
import { GFun } from "../libs/tc/util/GFun";
import iswx from "./iswx";
import getDefaultAvatar from "./getDefaultAvatar";

export default class ShareDreamScene extends Scene {

    type;
    id;
    async start(type?) {
        this.showlog();
        let { id2, address, avatar, url, content, title } = getRequest();

        this['from'].text = `来自${getProvince(decodeURIComponent(address))}的梦想`;
        this['idtxt'].text = `编号：${id2}`;
        this.id=id2;
        this['title'].text = decodeURIComponent(title);

        this.type = type;
        this['avatar'].mask = this['avatarMask'];
        this['img'].mask = this['imgMask'];
        this['avatarGroup'].visible = 1;

        if(avatar == 'null' || !avatar) {
            this['avatar'].source = getDefaultAvatar();
        }else {
            this['avatar'].source = decodeURIComponent(avatar);
        }
        
        this.loadImg(decodeURIComponent(url));

        content = decodeURIComponent(content);
        content = content.slice(0, 60) + '...';
        this['content'].text = content;

        this['scroll'].height = this.stage.stageHeight - this['scroll'].y - 10;

        this['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap, this);
    }

    ontap() {
        console.log('onTap_sharebtn');
        if (iswx()) {
            this['shareLayer'].visible = true;
            this['shareLayer'].once(egret.TouchEvent.TOUCH_TAP, () => {
                this['shareLayer'].visible = false;
            }, this);
        } else {
            let state = false;
            console.log('唤起app');
            state = true;
            const url1 =`${window['activeUrl']}?id=${this.id}`;
            const url = 'esports://openapp?url=http://aghzact.zjkczn.com/h5/defaultActive.html?activeUrl=' + encodeURIComponent(url1);
            window.location.href = url;

            let timer = setTimeout(() => {
                state = false;
                window.location.href = 'http://a.app.qq.com/o/simple.jsp?pkgname=com.fan.asiangameshz';
            }, 3000);

            // 唤端成功清除定时器
            document.addEventListener('visibilitychange', function () {
                if (document.visibilityState === 'hidden') {
                    if (state) {
                        if (timer) {
                            clearTimeout(timer)
                            timer = null;
                        }
                        state = false;
                    }
                }
            });
        }
    }

    loadImg(url) {
        RES.getResByUrl(url, (img: egret.Texture) => {
            // if (this.type == HisDreamType.SHARE) {
            this['imgGroup'].height = this['imgbg'].height;
            const maskRatio = this['imgMask'].width / this['imgMask'].height;
            this['img'].source = img;
            const imgRatio = img.textureWidth / img.textureHeight;
            if (imgRatio < maskRatio) {
                const scale = this['imgMask'].width / img.textureWidth;
                this['img'].width = this['imgMask'].width;
                this['img'].height = img.textureHeight * scale;
                this['img'].y = 5.1 - this['img'].height / 2 + this['imgMask'].height / 2;
            } else {
                const scale2 = this['imgMask'].height / img.textureHeight;
                this['img'].height = this['imgMask'].height;
                this['img'].width = img.textureWidth * scale2;
                this['img'].x = 31.7 - this['img'].width / 2 + this['imgMask'].width / 2;
            }
            // }
        }, this, RES.ResourceItem.TYPE_IMAGE)
    }
    get resKey(): string { return 'noname' }
    get skinKey() { return 'ShareDream' }

    showlog() { }


}