import wait from "../libs/new_tc/wait";
import Scene from "../libs/new_wx/components/Scene";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import { Buried } from "../libs/tw/util/Buried";
import join_1_index from "./interfaces/join_1_index";
import join_1_index_data from "./interfaces/join_1_index_data";
import MainBase from "./MainBase";
import { ReFuseType } from "./panels/SuccessPanel";
import StarAni from "./StarAni";
import { IntroType } from "./IntroScene";
import { DreamSceneType } from "./DreamScene";
import { getEnergyLimit } from "./datas";
import StarComp from "./StarComp";
import { getProvince } from "./MyDreamScene";
import sort from "./sort";
let isFirstShow = true;
let _myInfo;
export const getMyInfo = () => { return _myInfo };
export const updateMyInfo = () => {
    return new Promise((r) => {
        NetManager.ins.yyh_join1_dreamDetail(() => {
            _myInfo = DataManager.ins.getData('yyh_join1_dreamDetail').data;
            r(_myInfo);
        }, true)
    })
};
export default class MainScene extends Scene {
    starWrapper: eui.Group;
    setProgress(num, max) {
        if (num == null) num = 0;
        this['progressTxt'].text = `${num}/${max}`;
        this['imgMask'].scaleY = num > max ? 1 : num / max;
    }

    setNormal(isNormal, rightnow = false, first = false) {//first 刷新页面的情况
        const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        return new Promise((r) => {
            this['starWrapper']['isNormal'] = isNormal;
            if (isNormal) {
                this['tips'].visible = false;
                if (this.stars)
                    this.stars.forEach(item => {
                        egret.Tween.removeTweens(item);
                        egret.Tween.get(item).to({ alpha: 0 }, 300).call(() => { this.removeChild(item) });
                    });
                this.stars = [];
                if (first) {
                    this['starbtn'].alpha = 1;
                } else {
                    this['starbtn'].alpha = 0;
                    egret.Tween.get(this['starbtn']).set({ scaleX: 0, scaleY: 0 }).to({ alpha: 1, scaleX: 1, scaleY: 1 }, 200, egret.Ease.getBackOut(5)).wait(400).to({ alpa: 1, x: 680.51, y: 176 }, 500);
                    egret.Tween.get(this['starWrapper']).wait(600).to({ x: 374, y: 562, scaleY: 1, scaleX: 1 }, 500, egret.Ease.backIn).call(() => {
                        this.playShakeAni();
                        this['starbtn'].alpha = 1;
                    });
                }
            } else {
                egret.Tween.get(this['starbtn']).set({ x: 680.51, y: 176, alpha: 1 }).to({ alpha: 0, x: 375, y: 575 }, 700);
                this.stopShakeAni();
                this.updateStars(join_1_index.data.dreamList);
                egret.Tween.get(this['starWrapper']).to({ x: 666 + 10, y: 135 + 30, scaleX: 0.15, scaleY: 0.15 }, rightnow ? 1 : 500, egret.Ease.backIn).call(() => {
                    this['tips'].visible = true;
                    this.stars.forEach((item, index) => {
                        wait(index * 1000).then(() => {
                            egret.Tween.get(item).set({ alpha: 0 }).to({ alpha: 1 }, 1000).call(() => {
                                const y = this.pos[index][1];
                                const stren = 20; const dur = 2000;
                                egret.Tween.get(item, { loop: true }).set({ y: y }).to({ y: y - stren }, dur).to({ y: y }, dur)
                                    .to({ y: y + stren }, dur).to({ y: y }, dur)
                            });
                        });
                    });
                });
            }
        });
    }

    ontap_starWrapper() {
        this['starWrapper'].touchEnabled = false;
        this['starWrapper'].touchChildren = false;
        wait(1500).then(() => {
            this['starWrapper'].touchEnabled = true;
            this['starWrapper'].touchChildren = true;
        });
        this.setNormal(!this['starWrapper']['isNormal']);
    }

    async start(d?) {
        this.showlog();
        this['maskImg'].mask = this['imgMask'];
        this.setProgress(0, 1);
        this['rulebtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_rulebtn, this);
        this['dreambtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_dreambtn, this);
        this['listbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_listbtn, this);

        this.playStarAni();
        this.onResume_mainscene();

        MainBase.onResume_mainscene = this.onResume_mainscene;

        const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        this.showPanels(join_1_index.data);

        if (isFirstShow) {
            isFirstShow = false;

            this.setNormal(1, false, true);
            this['starbtn'].touchEnabled = false;

            setTimeout(() => {
                this['starbtn'].touchEnabled = true;
                this.setNormal(0);
                this['starWrapper'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_starWrapper, this);
            }, 3000);
        } else {
            this.setNormal(0, true);
            this['starWrapper'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_starWrapper, this);
        }
        const detail: any = await updateMyInfo()
        this.setProgress(join_1_index.data.currentLightUpCount, join_1_index.data.lightUpCount);
    }

    stars: any[];
    pos = [[70, 350], [480, 300], [100, 800], [300, 550], [450, 750]];
    updateStars(list: any[]) {
        if (list.length > 5)
            list.length = 5;
        this.stars = [];
        list.forEach((item, index) => {
            const star = new StarComp(`来自${getProvince(item.address)}的梦想`, item.id);
            star.x = this.pos[index][0];
            star.y = this.pos[index][1];
            star.alpha = 0;
            this.stars.push(star);
            this.addChild(star);
        })
    }

    showPanels(data: join_1_index_data) {
        if (data.lightUpWindow)
            PanelCtrl.instance.show('SuccessPanel'); //成功点亮

        if (data.reviewFailedWindow) {
            if (new Date().getTime() > data.reviewDeadline) {//过期
                PanelCtrl.instance.show('ReFusePanel', ReFuseType.TIMEOUT);//拒绝，超时 or 正常
            } else {
                PanelCtrl.instance.show('ReFusePanel', ReFuseType.ReFuse);//拒绝，超时 or 正常
            }
        }

        if (data.reviewPassedWindow)
            PanelCtrl.instance.show('PassPanel');//审核通过弹窗
    }

    onResume_mainscene = () => {
        StarAni.reset(this);
    }

    private playShakeAni() {
        const y0 = 562;
        const stren = 50;
        const dur = 2000;
        egret.Tween.get(this['starWrapper'], { loop: true })
            .to({ y: y0 + stren }, dur)
            .to({ y: y0 }, dur)
            .to({ y: y0 - stren }, dur)
            .to({ y: y0 }, dur);
    }

    private stopShakeAni() {
        const y0 = 562;
        const stren = 50;
        const dur = 2000;
        egret.Tween.removeTweens(this['starWrapper']);
    }

    playStarAni() {
        this['star'].visible = false;
        wait(2000).then(() => {
            this['star'].visible = true;
            egret.Tween.get(this['star'], { loop: true })
                .set({ x: -176, y: 466, alpha: 1 }).to({ x: 647, y: 1256.91, alpha: 0 }, 2000)
                .wait(3000)
                .set({ x: -183, y: 193.27, alpha: 1 }).to({ x: 883, y: 1126.6, alpha: 0 }, 2000)
                .wait(3000)
                .set({ x: -17, y: 0, alpha: 1 }).to({ x: 815, y: 456 + 200, alpha: 0 }, 2000)
                .wait(3000)
        });
    }

    ontap_rulebtn() {
        PanelCtrl.instance.show('RulePanel');
    }
    ontap_dreambtn() {
        //dreamStatus   -1 没有提交过，0 已经提交待审核，1已经提交已经通过 2已提交拒绝
        const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        const detail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
        if (detail.dreamStatus == '-1') {//如果没有提交过
            if (new Date().getTime() > join_1_index.data.reviewDeadline) {//过期
                SceneCtrl.instance.change('IntroScene', IntroType.TIMEOUT);
            } else {
                SceneCtrl.instance.change('IntroScene', IntroType.Intro);//活动介绍 过期 or 正常
            }
        } else if (detail.dreamStatus == '0') {
            SceneCtrl.instance.change('DreamScene', DreamSceneType.IN_PROGRESS);
        } else if (detail.dreamStatus == '1') {
            SceneCtrl.instance.change('MyDreamScene');//我的dream，已经通过
        } else if (detail.dreamStatus == '2') {
            if (new Date().getTime() > join_1_index.data.reviewDeadline)
                SceneCtrl.instance.change('DreamScene', DreamSceneType.TIME_OUT);
            else
                SceneCtrl.instance.change('DreamScene', DreamSceneType.RESUBMIT);
        }
    }

    ontap_listbtn() {
        SceneCtrl.instance.change('ListScene');
    }

    get skinKey() { return 'MainScene' }

    showlog() { }
}

export const getlogItem = (i) => {
    const Dpm = Buried.connectDpm(110, i, 1); // 点击埋点
    const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
    return Buried.createExposure(Dpm, Dcm);
}