import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { HtmlTextParser } from "../libs/new_wx/HtmlTextParser";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import getsubmitUrl from "./getsubmitUrl";
import join_1_index from "./interfaces/join_1_index";
import setBackBtn from "./setBackBtn";

export default class IntroScene extends Scene {

    async start(data?) {
        super.start();
        this.showlog();
        setBackBtn(this);
        this[`status${data}`].visible=true;
        this['btn0'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.ontap_btn0,this);
        this['btn1'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.ontap_btn1,this);
        this['lab1'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.ontap_lab1,this);

        this['content'].textFlow = (new HtmlTextParser).parser(window['activeRule']);

        const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        this['dead'].text = `截止时间：${new Date(join_1_index.data.reviewDeadline).toLocaleDateString()}`;
    }

    ontap_lab1(){
        NetManager.ins.yyh_join1_index(async (success) => {
            SceneCtrl.instance.change('MainScene');
        });
    }

    ontap_btn0(){
        getsubmitUrl();
    }
    ontap_btn1(){
        
    }

    get skinKey() { return 'Intro' }

    showlog() { }


}
export enum IntroType {
    TIMEOUT=0,
    Intro=1
}