import Scene from "../libs/new_wx/components/Scene";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { showToast } from "../libs/new_wx/ctrls/toastCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
import join_1_index from "./interfaces/join_1_index";
import { getProvince } from "./MyDreamScene";
import { NetManager } from "../libs/tw/manager/NetManager";
import setBackBtn from "./setBackBtn";
import getDefaultAvatar from "./getDefaultAvatar";
import getDefaultPic from "./getDefaultPic";

export default class HisDreamScene extends Scene {
    type;
    async start(type?) {
        this.showlog();
        setBackBtn(this, 'ListScene');
        const yyh_join1_dreamDetail = DataManager.ins.getData('yyh_join1_dreamDetail').data;

        this.type = type;
        this['avatar'].mask = this['avatarMask'];
        this['img'].mask = this['imgMask'];

        this['avatarGroup'].visible = 1;
        if (yyh_join1_dreamDetail.avatar == 'null' || !yyh_join1_dreamDetail.avatar) {
            this['avatar'].source = getDefaultAvatar();
        } else
            this['avatar'].source = yyh_join1_dreamDetail.avatar;

        this['from'].text = `来自${getProvince(yyh_join1_dreamDetail.address)}的梦想     编号：${yyh_join1_dreamDetail.id}`;
        this['rank'].text = `能量值：${yyh_join1_dreamDetail.energy}    梦想排名：${yyh_join1_dreamDetail.rank}`;
        this['title'].text = yyh_join1_dreamDetail.dreamTitle;
        this['content'].text = yyh_join1_dreamDetail.dreamContent;


        this.loadImg(yyh_join1_dreamDetail.dreamPic || getDefaultPic());

        this['scroll'].height = this.stage.stageHeight - this['scroll'].y - 10;

        this['backBtn'].once(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this['sharebtn'].once(egret.TouchEvent.TOUCH_TAP, this.onTap_sharebtn, this);

        this['group'].removeChild(this['status0']);
        this['group'].removeChild(this['status1']);
        this['group'].removeChild(this['status2']);
        this['group'].removeChild(this['status3']);
        this['group'].removeChild(this['status4']);
        this['group'].removeChild(this['status5']);
        this['group'].removeChild(this['status6']);
        this.status = type;

        this['helpbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_helpbtn, this);

        const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        this['limtText'].text = `(${join_1_index.data.doAssistLimit}/${join_1_index.data.doAssistLimit})`;
        this['helpStatusTxt'].text = `每天可给${join_1_index.data.doAssistLimit}个梦想充能(${join_1_index.data.doAssistCount}/${join_1_index.data.doAssistLimit})`;
    }

    ontap_helpbtn() {
        const panel = PanelCtrl.instance.show('CostPanel');
        panel.once('onDestroy', this.onCostPanelHide, this);
    }

    onCostPanelHide = (e: egret.Event) => {
        const success = e.data.extra;
        console.log('onCostPanelHide', e.data);
        if (success) {
            this['group'].removeChild(this['status' + HisDreamType.ENOUPH_TIMES]);
            this.status = HisDreamType.HELP_DONE;
            showToast('梦想充能成功');
        }
    }

    set status(nums) {
        this['group'].addChildAt(this['status' + nums], 2);
    }

    loadImg(url) {
        RES.getResByUrl(url, (img: egret.Texture) => {
            const oriHeight = this['img'].height;
            const scale = this['imgMask'].width / img.textureWidth;
            this['img'].source = img;
            this['img'].height = img.textureHeight * scale;
            const addHeight = this['img'].height - oriHeight;
            this['imgMask'].height = this['img'].height;
            this['imgbg'].height = this['imgbg'].height + addHeight;
        }, this, RES.ResourceItem.TYPE_IMAGE)
    }

    onTap_sharebtn() {
        console.log('onTap_sharebtn')
    }
    onTap_ruleBtn() {
        NetManager.ins.yyh_join1_index(async (success) => {
            SceneCtrl.instance.change('MainScene');
        });
    }

    get skinKey() { return 'HisDream' }
    get resKey() { return 'noname' }

    showlog() { }


}

export enum HisDreamType {
    START = 0,
    HELP_DONE = 1,
    TIMES_LIMIT = 2,
    TIMES_OUT = 3,
    MONEY_NOT_ENOUPH = 4,
    // SHARE = 5,
    ENOUPH_TIMES = 6
}