import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { IntroType } from "./IntroScene";
import { DataManager } from "../libs/tw/manager/DataManager";
import getsubmitUrl from "./getsubmitUrl";
import join_1_index from "./interfaces/join_1_index";
import { NetManager } from "../libs/tw/manager/NetManager";
import setBackBtn from "./setBackBtn";
import getDefaultPic from "./getDefaultPic";
export enum DreamSceneType {
    IN_PROGRESS=0,
    RESUBMIT=1,
    TIME_OUT=2,//重新提交但是审核时间已过
}

export default class DreamScene extends Scene {
    async start(data?) {
        super.start();
        this.showlog();
        const yyh_join1_dreamDetail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
        this['group'].removeChild(this['status0']);
        this['group'].removeChild(this['status1']);
        this['group'].removeChild(this['status2']);
        setBackBtn(this);
        this.status = data;

        this['img'].mask = this['imgMask'];
        if(this.stage.stageHeight < 1252)
            this['scroll'].height = this.stage.stageHeight - this['scroll'].y;

        
        this['resubmitBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.ontap_resubmitBtn,this);
        this['lab1'].once(egret.TouchEvent.TOUCH_TAP,this.ontap_lab1,this);

        this['nametxt'].text = yyh_join1_dreamDetail.name;
        this['phone'].text = yyh_join1_dreamDetail.tel;
        this['idtxt'].text = yyh_join1_dreamDetail.idNumber;
        this['addresstxt'].text = yyh_join1_dreamDetail.address.split(',').join('-');
        this['title'].text =yyh_join1_dreamDetail.dreamTitle;
        this['content'].text =yyh_join1_dreamDetail.dreamContent;
        this.loadImg(yyh_join1_dreamDetail.dreamPic|| getDefaultPic());
    }

    ontap_lab1(){
        NetManager.ins.yyh_join1_index(async (success) => {
            SceneCtrl.instance.change('MainScene');
        });
    }

    ontap_resubmitBtn(){
        // const join_1_index: join_1_index = DataManager.ins.getData('yyh_join1_index');
        //如果时间过了，那么去
        // SceneCtrl.instance.change('IntroScene',IntroType.TIMEOUT);
        //时间没有过，可以重新填写
        getsubmitUrl();
    }

    set status(nums) {
        this['group'].addChildAt(this['status'+nums],3);
    }

    loadImg(url) {
        // const url = 'http://yun.duiba.com.cn/db_games/img1.png';
        // const url = 'http://yun.duiba.com.cn/db_games/img2.jpg';
        RES.getResByUrl(url, (img: egret.Texture) => {
            const oriHeight = this['img'].height;
            const scale = this['imgMask'].width / img.textureWidth;
            this['img'].source = img;
            this['img'].height = img.textureHeight * scale;
            const addHeight = this['img'].height - oriHeight;
            this['imgMask'].height = this['img'].height;
            this['imgbg'].height = this['imgbg'].height + addHeight;
        }, this, RES.ResourceItem.TYPE_IMAGE)
    }

    ontap_rulebtn(){
        
    }

    get skinKey() { return 'Dream' }
    get resKey() { return 'noname' }

    showlog() { }


}

