import Scene from "../libs/new_wx/components/Scene";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
import setBackBtn from "./setBackBtn";
import getDefaultPic from "./getDefaultPic";

export default class DreamAdminScene extends Scene {
    list: eui.List;
    id;
    async start(data?) {
        super.start();
        this.showlog();
        this.id = data.id;
        setBackBtn(this,'AdminScene');

        this['img'].mask = this['imgMask'];
        this['scroll'].height = this.stage.stageHeight - this['scroll'].y;

        this['btn1'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_btn1, this);
        this['btn2'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_btn2, this);
        const yyh_join1_dreamDetail = DataManager.ins.getData('yyh_join1_dreamDetail').data;
        this['nametxt'].text = yyh_join1_dreamDetail.name;
        this['phone'].text = yyh_join1_dreamDetail.tel;
        this['idtxt'].text = yyh_join1_dreamDetail.idNumber;
        this['addresstxt'].text = yyh_join1_dreamDetail.address.split(',').join('-');
        this['title'].text = yyh_join1_dreamDetail.dreamTitle;
        this['content'].text = yyh_join1_dreamDetail.dreamContent;
        this.loadImg(yyh_join1_dreamDetail.dreamPic || getDefaultPic());
    }

    ontap_btn1() {
        console.log('通过');
        PanelCtrl.instance.show('AdminPanel',{id:this.id});
    }
    ontap_btn2() {
        console.log('不通过');
        PanelCtrl.instance.show('AdminPanel2',{id:this.id});
    }

    loadImg(url) {
        RES.getResByUrl(url, (img: egret.Texture) => {
            const oriHeight = this['img'].height;
            const scale = this['imgMask'].width / img.textureWidth;
            this['img'].source = img;
            this['img'].height = img.textureHeight * scale;
            const addHeight = this['img'].height - oriHeight;
            this['imgMask'].height = this['img'].height;
            this['imgbg'].height = this['imgbg'].height + addHeight;
        }, this, RES.ResourceItem.TYPE_IMAGE)
    }

    get skinKey() { return 'DreamAdmin' }
    get resKey() { return 'noname' }

    showlog() { }


}