import Scene from "../libs/new_wx/components/Scene";
import AdminItemRenderer from "./AdminItemRenderer";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import setBackBtn from "./setBackBtn";

export default class AdminScene extends Scene {
    list: eui.List;
    async start(data?) {
        super.start();
        this.showlog();

        setBackBtn(this);

        this['scroll'].height = this.stage.stageHeight - this['scroll'].y;

        this.list.useVirtualLayout = true;
        this.list.itemRenderer = AdminItemRenderer;

        NetManager.ins.yyh_join1_reviewDreamList(() => {
            let datalist = DataManager.ins.getData('yyh_join1_reviewDreamList').data;
            datalist.forEach(item => {
                item.func = this.onTap_detail
            });
            const ac = new eui.ArrayCollection(
                datalist
            );
            this.list.dataProvider = ac;
        });
    }

    onTap_detail = (id) => {
        this.touchChildren = false;
        this.touchEnabled = false;
        NetManager.ins.yyh_join1_dreamDetail((success) => {
            this.touchChildren = true;
            this.touchEnabled = true;
            if (success)
                SceneCtrl.instance.change('DreamAdminScene', { id: id });
        }, false, id);

    }

    get skinKey() { return 'Admin' }

    showlog() { }


}