import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
import { IRankData } from '../../data/game/winranks/IRankData';
export class GameWinnerModel extends GameModel {
    /**
     * 排名文案
     * @param rankStr 
     */
    public getRankTxt(rankStr: string = TwLang.lang_020): string {
        if(DataManager.ins.winRanksData.consumer.rank == "?") {
            return GFun.replace(TwLang.lang_019, [DataManager.ins.winRanksData.consumer.rank || '0']);
        }
        return GFun.replace(rankStr, [DataManager.ins.winRanksData.consumer.rank]);
    }

    /**
     * 奖品文案
     * @param winningStr 
     * @param notWinningStr 
     * @param notJoinStr 
     */
    public getOptionTxt(winningStr: string = TwLang.lang_021, notWinningStr: string = TwLang.lang_022, notJoinStr: string = TwLang.lang_024): string {
        let str: string;
        //是否参与过游戏
        if (DataManager.ins.winRanksData.consumer.join) {
            //是否中奖
            if (DataManager.ins.winRanksData.consumer.option) {
                str = GFun.replace(winningStr, [DataManager.ins.winRanksData.consumer.option]);
            } else {
                str = notWinningStr;
            }
        } else {
            str = notJoinStr;
        }
        return str;
    }

    /**
     * 用户ID文案
     * @param str 
     */
    public getConsumerTxt(str: string = TwLang.lang_023): string {
        return GFun.replace(str, [DataManager.ins.winRanksData.consumer.cid])
    }

    /**
     * 排行列表
     */
    public get rankList(): IRankData[] {
        return DataManager.ins.winRanksData.rankList;
    }
}