import getResPath from "../new_tc/getResPath";

const loadJSON = () => {
    return new Promise((resolve: (value: any) => void) => {
        const respHandler_onComplete = (evt: egret.Event) => {
            const request: egret.HttpRequest = evt.currentTarget;
            resolve(JSON.parse(request.response));
        };
        const urlJSON = getResPath() + "resource/TextureMerger/loading.json";
        const request = new egret.HttpRequest();
        request.once(egret.Event.COMPLETE, respHandler_onComplete, null);
        request.open(urlJSON, egret.HttpMethod.GET);
        request.send();
    });

}

const loadImage = () => {
    return new Promise((resolve: (value: egret.Texture) => void) => {
        const oncomplete = (e: egret.Event) => {
            const imageLoader: egret.ImageLoader = e.currentTarget;
            const bitmapData: egret.BitmapData = imageLoader.data;
            const texture = new egret.Texture();
            texture._setBitmapData(bitmapData);
            resolve(texture);
        }
        const url = getResPath() + "resource/TextureMerger/loading.png";
        const imageLoader = new egret.ImageLoader();
        imageLoader.load(url);
        imageLoader.once(egret.Event.COMPLETE, oncomplete, this)
    });
}

const loadAll = () => {
    return Promise.all([loadJSON(), loadImage()])
}

const loadSpriteSheet = async () => {
    return new Promise(async (resolve: (value: egret.SpriteSheet) => void) => {
        const [json, atlas] = await loadAll();
        const frames: any = json.frames;
        const spriteSheet = new egret.SpriteSheet(atlas);
        for (const subkey in frames) {
            const config: any = frames[subkey];
            const texture = spriteSheet.createTexture(subkey, config.x, config.y, config.w, config.h, config.offX, config.offY, config.sourceW, config.sourceH);
        }
        resolve(spriteSheet);
    })

}
export default loadSpriteSheet;





