import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";

const getHdGameOrderStatus = (callback: Function): void => {
    const dojoin = DataManager.ins.getData('dojoin');
    NetManager.ins.getNgameStartStatus(callback, dojoin.data, () => {
        const data = DataManager.ins.getData('getNgameStartStatus');
        return data.code == 'C000000001';
    });
}

/**
 * 活动工具类型游戏子类型抽奖
 * @param callback
 * @param nextStep 下一步做什么，轮询结果或者前置开奖等
 */
const hdGameDoDojoin = (callback: Function, collectRuleId?: number): void => {
    if (window['uid'] == 'not_login') {
        window['requirelogin']();
        return;
    }
    NetManager.ins.doJoin((success: boolean) => {
        if (success) {
            getHdGameOrderStatus(callback);
        } else {
            callback(success);
        }
    });
}

export default hdGameDoDojoin