import Panel from "../../MVC/views/Panel";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { NetName } from "../../../libs/tw/enum/NetName";
import { PrizeTypes } from "../../Scene/startScene/RotaryData";
import { NetManager } from "../../../libs/tw/manager/NetManager";

export default class PrizePanel extends Panel {
	public closeBtn: eui.Button;
	public prizeImg: eui.Image;
	public prizeName: eui.Label;
	public ok_btn: eui.Button;

	public get skinKey() { return 'PrizePanel' }
	public get groupName() { return 'prize_panel' }

	private url: string;

	constructor(data?) {
		super(data);

	}
	initEvents() {
		this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
		this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	touch_tap_ok_btn() {
		if (this.data == 'coupon') {	// 如果是优惠卷则查询链接并跳转
			let userRecordId = DataManager.ins.getData(NetName.GET_PRIZE).data.userRecordId;
			NetManager.ins.getCouponInfo((success) => {
				if (!success) {
					return;
				}
				let link = DataManager.ins.getData(NetName.GET_COUPON_INFO).data.link;
				window.location.href = link;
			}, userRecordId, () => {
				let data = DataManager.ins.getData(NetName.GET_COUPON_INFO);
				return !(data.success && data.code == '0000000000')
			}, 10);

		} else {	// 不是优惠卷直接跳转链接
			window.location.href = this.url;
		}

	}

	removeEvents() {
		this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
		this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}



	protected onSkinComplete(): void {
		super.onSkinComplete();

		this.preLoadRes();
		this.onLoad();

	}

	protected onLoad(): void {
		this.initUI();
		this.url = this.data;
	}

	private initUI(): void {
		let data = DataManager.ins.getData(NetName.QUERY_PRIZE_INFO).data;
		this.prizeImg.source = data[0].icon;
		this.prizeName.text = data[0].name;
	}

	protected async preLoadRes() {

		return new Promise(function (resolve, reject) {
			resolve();
		});
	}
}