import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getToken } from "../const";


export default class StartItem extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('Item');
    }
    /**
     * activityStatus:
     * 0:未开始
     * 1:进行中
     * 2:已结束
     */
    dataChanged() {
        this.touchChildren = false;
        if (this.data.activityStatus != 0) {
            if (this.hasEventListener(egret.TouchEvent.TOUCH_TAP)) return;
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                this.touchEnabled = false;
                setTimeout(() => {
                    if (this) this.touchEnabled = true;
                }, 2000)
                console.log("点击了", parseInt(this.data.activityId))
                if (this.data.activityStatus == 2) {
                    console.log("跳转了")
                    location.href = this.data.activityUrl;
                } else {
                    let activityId = parseInt(this.data.activityId);
                    // const { data } = DataManager.ins.getData('yyh_index');
                    if (activityId >= 3 && !isNaN(activityId)) {
                        getToken().then((token) => {
                            if (!token) {
                                showToast('网络异常，请稍后重试');
                                return;
                            }
                            NetManager.ins.yyh_light({ activityId: this.data.activityId, token: token }, (success, res) => {
                                console.log("调接口跳转了,,,-->>", res)
                                // alert(`调接口跳转了,,,-->>${JSON.stringify(res)}`)
                                if (!success) {
                                    showToast('网络异常，请稍后重试')
                                    return;
                                }
                                location.href = this.data.activityUrl;
                            })
                        }).catch(() => {
                            showToast('网络异常，请稍后重试')
                        })

                    } else {
                        location.href = this.data.activityUrl;
                    }
                }
            }, this);
        }

        this['img0'].visible = false;
        this['img2'].visible = false;
        this['img1'].visible = false;
        this['status0'].visible = false;
        this['status1'].visible = false;
        this['status2'].visible = false;
        this['status3'].visible = false;

        this[`status${this.data.userStatus}`].visible = true;
        this[`img${this.data.activityStatus}`].visible = true;

        if (this.data.userStatus == 3) {
            this[`img${this.data.activityStatus}`].visible = false;
        }

        if (this.data.activityStatus == 2 || this.data.activityStatus == 0) {
            if (this.data.userStatus != 3)
                this[`status${this.data.userStatus}`].visible = false;
        }
    }
}