import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
class RewardItem extends eui.ItemRenderer {
    icon1: eui.Image;
    icon2: eui.Image;
    numsTxt: eui.Label;
    nameTxt: eui.Label;
    timeTxt: eui.Label;
    dataChanged() {
        const isEnergy = this.data.isEnergy;
        const nums = this.data.nums;
        const name = this.data.name;
        this.icon1.visible = isEnergy;
        this.icon2.visible = !isEnergy;
        this.numsTxt.visible = isEnergy;
        if (isEnergy) {
            this.numsTxt.text = `${nums}个`;
            this.nameTxt.text = '能量'
        }
        else {
            this.nameTxt.text = name;
        }
        this.nameTxt.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            window.location.href = this.data.url;
        }, this)
        this.timeTxt.text = this.data.time;

    }
}
class InviteItem extends eui.ItemRenderer {
    dataChanged() {

    }
}
const getorigins = () => {
    // const pre = CFG.actId + '00';
    let plugs: any = window['plugs'];
    let list: any = [];
    // list.push(pre);
    plugs = plugs.map(p => p + '01');
    list = list.concat(plugs);
    return list.join(',')
}

export default class RewardPanel extends Panel {
    group1: eui.Group;
    group2: eui.Group;
    emptyTips1: eui.Image;
    emptyTips2: eui.Image;
    numsTxt: eui.Label;
    list1: eui.List;
    list2: eui.List;
    btn1: eui.Button;
    btn2: eui.Button;
    async start() {
        super.start();

        this.list1.visible = false;
        this.emptyTips1.visible = false;
        this.list2.visible = false;
        this.emptyTips2.visible = false;

        this.group1.visible = true;
        this.group2.visible = false;

        this.btn1.enabled = false;
        this.btn1.labelDisplay['textColor'] = 0x164e8f;
        this.btn2.enabled = true;
        this.btn2.labelDisplay['textColor'] = 0xffffff;

        // NetManager.ins.yyh_baseinfo(() => {
        //     const { data } = DataManager.ins.getData('yyh_baseInfo');
        //     this['numsTxt'].text = data.energyCountForever + '个';
        // });

        this.btn1.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.group1.visible = true;
            this.group2.visible = false;
            this.btn1.enabled = false;
            this.btn1.labelDisplay['textColor'] = 0x164e8f;
            this.btn2.enabled = true;
            this.btn2.labelDisplay['textColor'] = 0xffffff;
        }, this);
        this.btn2.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.group2.visible = true;
            this.group1.visible = false;
            this.btn2.enabled = false;
            this.btn2.labelDisplay['textColor'] = 0x164e8f;
            this.btn1.enabled = true;
            this.btn1.labelDisplay['textColor'] = 0xffffff;
        }, this);

        await Promise.all([NetManager.ins.yyh_getInviteRecords(), NetManager.ins.yyh_getRecord(getorigins())]);
        const list2data = DataManager.ins.getData('yyh_getInviteRecords').data;
        const list1data = DataManager.ins.getData('yyh_getRecord').records;

        this.list1.visible = list1data.length > 0;
        this.emptyTips1.visible = list1data.length <= 0;
        this.list2.visible = list2data.length > 0;
        this.emptyTips2.visible = list2data.length <= 0;

        this.list1.itemRenderer = RewardItem;
        this.list1.useVirtualLayout = false;
        this.list1.dataProvider = new eui.ArrayCollection(list1data.map(item => {
            return {
                isEnergy: item.itemType != "coupon",
                nums: item.title.replace(/[^0-9]/ig, ""),
                name: item.title,
                time: item.gmtCreate,
                url: item.url
            }
        }));

        this.list2.itemRenderer = InviteItem;
        this.list2.useVirtualLayout = false;
        this.list2.dataProvider = new eui.ArrayCollection(list2data.map(item => {
            const assistNickName = item.assistNickName;
            return {
                user: `${assistNickName.slice(0, 3)}****${assistNickName.slice(7)}`,
                time:this.getTimeStr(item.gmtCreate)
            }
        }));
    }

    getTimeStr(gmtCreate) {
        const d = new Date(gmtCreate);
        const y = d.getFullYear();
        const m = d.getMonth() + 1;
        const date = d.getDate();
        const h = d.getHours();
        const min = d.getMinutes();
        const s = d.getSeconds();
        return `${y}-${this.getNum(m)}-${this.getNum(date)} ${this.getNum(h)}:${this.getNum(min)}:${this.getNum(s)}`;
    }

    getNum(n) {
        return n >= 10 ? n : '0' + n;
    }

    initEvents() {
        super.initEvents();

    }

    get skinKey(): string { return 'Reward' }
}