import Scene from "../../libs/new_wx/components/Scene";
import { Buried } from "../../libs/tw/util/Buried";
import { DataManager } from "../../libs/tw/manager/DataManager";
import StartItem from "./StartItem";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";

export default class Start1Scene extends Scene {
    scroll: eui.Scroller;
    list: eui.List;
    async start(d?) {
        this.showlog();

        super.start();

        this.scroll.height = this.stage.stageHeight - this.scroll.y - 30;

        const { data } = DataManager.ins.getData('yyh_index');
        //2021-07-26 爱德迭代，这里废弃之前用图片表示的未点亮，该用group+label+img，灵活性更高
        // this['notLightImg'].visible = !data.lighten;
        this['noLightGroup'].visible = !data.lighten;
        this['lightImg'].visible = data.lighten;
        this['tips'].text = `我完成的活动${data.completeCount}个`;
        this.list.itemRenderer = StartItem;
        this.list.dataProvider = new eui.ArrayCollection(data.activityList);

        let showSuccess = false;
        if ( data.lighten == 1 && data.firstLighten) {
        // if (localStorage.getItem('yyh2_success') == null && data.lighten == 1 && data.firstLighten) {
            // localStorage.setItem('yyh2_success', "1");
            PanelCtrl.instance.show('SuccessPanel');
            showSuccess = true;
        }

        let completeIds = [];
        if (localStorage.getItem('yyh2_task') == null) {
            completeIds = [];
        } else {
            completeIds = JSON.parse(localStorage.getItem('yyh2_task'));
        }

        const currentTaskIds = data.activityList.filter(i => i.userStatus == 3).map(i => i.activityId);
        const newIds = currentTaskIds.filter(i => completeIds.indexOf(i) == -1);

        if (newIds && newIds.length > 0) {
            let newActs = data.activityList.
                filter(i => newIds.indexOf(i.activityId) != -1)
                .map((item, index, list) => {
                    if (index == list.length - 1)
                        return `${index + 1}、${item.activityName}`
                    return `${index + 1}、${item.activityName}\n`
                });
            if (newActs.length >= 4) newActs.length = 4;
            // console.log(newActs);


            //2021-07-27 爱德迭代修改，不需要这个弹窗了
            // if (!showSuccess)
                // PanelCtrl.instance.show('TaskPanel', newActs.join(''));

            localStorage.setItem('yyh2_task', JSON.stringify(currentTaskIds));
        }

        // setTimeout(() => {
        //     const list = data.activityList.filter(item => item.userStatus != 0);
        //     this.list.dataProvider = new eui.ArrayCollection(list);
        // }, 2000);

        // setTimeout(() => {
        //     this.list.dataProvider = new eui.ArrayCollection(data.activityList);
        // }, 5000);

        this.scroll.visible = false;
        this['pic1'].visible = false;
        this['pic2'].visible = false;

        if(data.activityList.length > 0) {
            this.scroll.visible = true;
        }else {
            this['pic1'].visible = true;
        }

        this['btn1'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.list.dataProvider = new eui.ArrayCollection(data.activityList);
            this['btn1'].size = 30;
            this['btn2'].size = 28;
            this['btn1'].textColor = 0x000000;
            this['btn1'].bold = true;
            this['btn2'].bold = false;
            this['btn2'].textColor = 0x878787;
            this['line1'].visible = true;
            this['line2'].visible = false;

            this.scroll.visible = false;
            this['pic1'].visible = false;
            this['pic2'].visible = false;

            if(data.activityList.length > 0) {
                this.scroll.visible = true;
            }else {
                this['pic1'].visible = true;
            }
            this.scroll.viewport.scrollV=0;
        }, this);

        this['btn2'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            const list = data.activityList.filter(item => item.userStatus != 0);
            this.list.dataProvider = new eui.ArrayCollection(list);
            this['btn2'].textColor = 0x000000;
            this['btn1'].textColor = 0x878787;
            this['line1'].visible = false;
            this['line2'].visible = true;
            this['btn2'].bold = true;
            this['btn1'].bold = false;
            this['btn2'].size = 30;
            this['btn1'].size = 28;
            this.scroll.visible = false;
            this.scroll.viewport.scrollV=0;
            this['pic1'].visible = false;
            this['pic2'].visible = false;

            if(list.length > 0) {
                this.scroll.visible = true;
            }else {
                this['pic2'].visible = true;
            }
        }, this);
    }

    initEvents() {
        // this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
    }

    onTap_giftbtn() {

    }


    get skinKey() { return 'Start1' }

    showlog() {
        // NetManager.ins.showLog(getlogItem(3));
    }
}

export const getlogItem = (i) => {
    const Dpm = Buried.connectDpm(110, i, 1); // 点击埋点
    const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
    return Buried.createExposure(Dpm, Dcm);
}